package com.tykj.datahouse.controller;

import com.google.common.collect.ImmutableMap;
import com.tykj.datahouse.base.result.ResultObj;
import com.tykj.datahouse.base.result.ResultUtil;
import com.tykj.datahouse.entity.TableInfo;
import com.tykj.datahouse.service.TableInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Api(tags = "表操作API")
@CrossOrigin
@RequestMapping("/table")
@RestController
public class TableInfoController {

    @Autowired
    private TableInfoService tableInfoService;


    @PostMapping
    @ApiOperation("创建一个新表")
    public ResponseEntity createTable(@RequestBody TableInfo tableInfo) {
        tableInfoService.createTable(tableInfo);
        return ResponseEntity.ok(ImmutableMap.of("message","操作成功"));
    }

    @PutMapping
    @ApiOperation("修改一个表")
    public ResponseEntity<ResultObj<Object>> alterTable(@RequestBody TableInfo tableInfo) {
        tableInfoService.alterTable(tableInfo);
        return ResultUtil.success("操作成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("按指定id删除一个表")
    public ResponseEntity<ResultObj<Object>> dropTable(@PathVariable Integer id) {
        tableInfoService.deleteTable(id);
        return ResultUtil.success("操作成功");
    }

    @GetMapping
    @ApiOperation("查询当前所有表")
    public ResponseEntity<ResultObj<List<TableInfo>>> findAll() {
        List<TableInfo> all = tableInfoService.findAll();
        return ResultUtil.success(all, "查询成功");
    }

}
