package com.tykj.datahouse.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.List;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class ColumnInfo {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    //-----------------------------//

    @ApiModelProperty(value = "是否是主键 true/false", position = 1)
    private Boolean isPrimary;

    @ApiModelProperty(value = "列名", position = 2)
    private String name;

    @ApiModelProperty(value = "别名", position = 3)
    private String alias;

    @ApiModelProperty(value = "列类型", position = 4)
    private String type;

    @ApiModelProperty(value = "长度", position = 5)
    private Integer length;

    @ApiModelProperty(value = "长度", position = 5)
    private Boolean notNull;

    @ApiModelProperty(value = "描述", position = 6)
    private String description;

    @JsonIgnore
    private Integer tableInfoId;

}
