package com.tykj.datahouse.service;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.util.Map;

/**
 * 数据源管理Service
 * 可以动态增加和切换数据源
 */
@Service
public class DataSourceManager {

    @Autowired
    private DataSource dataSource;

    private BasicDataSourceCreator dataSourceCreator = new BasicDataSourceCreator(new DynamicDataSourceProperties());

    public Map<String,DataSource> getDataSources(){
        return ((DynamicRoutingDataSource) dataSource).getDataSources();
    }

    public void addDataSource(String name) {
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        DataSource basicDataSource = dataSourceCreator.createDataSource(dataSourceProperty);
        ((DynamicRoutingDataSource) dataSource).addDataSource(name, basicDataSource);
    }

    public void switchToDataSource(String dataSourceName) {
        DynamicDataSourceContextHolder.push(dataSourceName);
    }

    public void clear() {
        DynamicDataSourceContextHolder.clear();
    }

}
