package com.tykj.datahouse.sql;

import com.tykj.datahouse.entity.ColumnInfo;
import com.tykj.datahouse.entity.TableInfo;

import java.util.List;
import java.util.Map;

/**
 * sql语句生成器
 * 根据不同的操作对应不同的API
 * 输入表信息或字段信息 返回对应的sql语句结果
 */
public interface SqlCreator {

    /**
     * 创建新表
     * @param tableInfo 要创建的表
     * @return 对应的sql语句结果
     */
    String createTableSql(TableInfo tableInfo);

    /**
     * 在表中添加字段
     * @param tableInfo 被修改的表
     * @param columnInfo 要添加的字段
     * @return 对应的sql语句结果
     */
    String addColumnSql(TableInfo tableInfo, ColumnInfo columnInfo);

    /**
     * 修改表中的字段
     * @param tableInfo 被修改的表
     * @param oColumnInfo 原字段
     * @param columnInfo 现字段
     * @return 对应的sql语句结果
     */
    String alterColumnSql(TableInfo tableInfo, ColumnInfo oColumnInfo,ColumnInfo columnInfo);

    /**
     *
     * @param tableInfo 被修改的表
     * @param columnInfo 要删除的字段
     * @return 对应的sql语句结果
     */
    String removeColumnSql(TableInfo tableInfo, ColumnInfo columnInfo);

    /**
     * 删除表
     * @param tableInfo 被删除的表
     * @return 对应的sql语句结果
     */
    String dropTableSql(TableInfo tableInfo);

    /**
     * 插入一条数据
     * @param tableInfo 被插入数据的表
     * @param row Map形式的数据对象
     * @return 对应的sql语句结果
     */
    String insertSql(TableInfo tableInfo, Map<String, Object> row);

    /**
     * 更新一条数据
     * @param tableInfo 被更新数据的表
     * @param row Map形式的数据对象
     * @return 对应的sql语句结果
     */
    String updateSql(TableInfo tableInfo, Map<String, Object> row);

    /**
     * 删除一条数据
     * @param tableInfo 被删除数据的表
     * @param row Map形式的数据对象
     * @return 对应的sql语句结果
     */
    String deleteSql(TableInfo tableInfo, Map<String, Object> row);

    String querySql(String tableName, List<String> columns);

}
