package com.tykj.datahouse;

import com.tykj.datahouse.entity.ColumnInfo;
import com.tykj.datahouse.entity.TableInfo;
import com.tykj.datahouse.repository.ColumnInfoRepository;
import com.tykj.datahouse.repository.TableInfoRepository;
import com.tykj.datahouse.service.TableInfoService;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.HashMap;
import java.util.Map;

@SpringBootTest
class DatahouseApplicationTests {

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TableInfoService tableInfoService;

    @Test
    void test() {
        tableInfoService.updateData(2, row());
        print();
    }

    Map<String, Object> row() {
        Map<String, Object> row = new HashMap<>();
        row.put("id", 1);
        row.put("name", "c");
        row.put("age", 20);
        return row;
    }

    ColumnInfo columnInfo() {
        return new ColumnInfo(
                null,
                false,
                "name",
                "名字",
                "varchar",
                255,
                true,
                "",
                1
        );
    }

    ColumnInfo columnInfo2() {
        return new ColumnInfo(
                null,
                false,
                "name2",
                "名字",
                "varchar",
                255,
                true,
                "",
                1
        );
    }

    ColumnInfo columnInfo3() {
        return new ColumnInfo(
                null,
                false,
                "name3",
                "名字",
                "varchar",
                255,
                true,
                "",
                1
        );
    }

    TableInfo oTableInfo() {
        return new TableInfo(
                null,
                null,
                null,
                "student",
                "学生",
                "",
                Lists.newArrayList(
                        new ColumnInfo(
                                null,
                                true,
                                "id",
                                "主键",
                                "int",
                                null,
                                true,
                                "",
                                1
                        ),
                        new ColumnInfo(
                                null,
                                false,
                                "name",
                                "名字",
                                "varchar",
                                255,
                                true,
                                "",
                                1
                        ),
                        new ColumnInfo(
                                null,
                                false,
                                "age",
                                "年龄",
                                "int",
                                null,
                                false,
                                "",
                                1
                        )
                )
        );
    }

    TableInfo tableInfo() {
        return new TableInfo(
                1,
                null,
                null,
                "student",
                "学生",
                "",
                Lists.newArrayList(
                        new ColumnInfo(
                                1,
                                true,
                                "id",
                                "主键",
                                "int",
                                null,
                                true,
                                "",
                                1
                        ),
                        new ColumnInfo(
                                2,
                                false,
                                "name2",
                                "名字",
                                "varchar",
                                11,
                                true,
                                "",
                                1
                        ),
                        new ColumnInfo(
                                null,
                                false,
                                "age2",
                                "年龄",
                                "int",
                                null,
                                false,
                                "",
                                1
                        )
                )
        );
    }

    void print() {
        for (TableInfo tableInfo : tableInfoService.findAll()) {
            System.out.println("-----------------------------------");
            System.out.println(tableInfo);
            for (ColumnInfo columnInfo : tableInfo.getColumnInfos()) {
                System.out.println(columnInfo);
            }
        }
    }

}
