package com.example.sqlserver.collector.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

/**
 * @author C
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryLocation",
        transactionManagerRef = "transactionManagerLocation",
        basePackages = {
                "com.example.sqlserver.collector.repository.local"
        }
)
@EnableConfigurationProperties(JpaProperties.class)
public class LocationConfig {
    @Autowired
    @Qualifier("localDataSource")
    private DataSource locationDataSource;

    @Primary
    @Bean(name = "entityManageLocation")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryLocation(builder).getObject().createEntityManager();
    }

    @Primary
    @Bean(name = "entityManagerFactoryLocation")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryLocation(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(locationDataSource)
                .properties(getVendorProperties(locationDataSource))
                .packages(
                        "com.example.sqlserver.collector.entity.local"
                )
                .persistenceUnit("locationPersistenceUnit")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;

    private Map<String, String> getVendorProperties(DataSource dataSource) {
        return jpaProperties.getHibernateProperties(dataSource);
    }

    @Primary
    @Bean(name = "transactionManagerLocation")
    public PlatformTransactionManager transactionManagerLocation(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryLocation(builder).getObject());
    }
}

