package com.example.sqlserver.collector.entity.local;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/18 14:26
 * <p>@author : C
 * 文章
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "dc_article")
public class Article {

    @Id
    @Column(name = "ALE_UUID", length = 48, nullable = false)
    private String uuid;

    @Column(name = "ALE_CREATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date createDate;

    @Column(name = "ALE_UPDATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date updateDate;

    /**
     * 栏目id
     */
    @Column(name = "ALE_CH_UUID", length = 48)
    private String chUUID;

    @Column(name = "ALE_TITLE", length = 128)
    private String title;

    @Column(name = "ALE_FDATE", columnDefinition = "date")
    private Date pubDate;

    @Column(name = "ALE_ORDER_TIME", columnDefinition = "date")
    private Date orderTime;

    @Column(name = "ALE_EXAMINE_TIME", columnDefinition = "date")
    private Date examineTime;

    @Column(name = "ALE_AUTHOR", length = 100)
    private String author;

    /**
     * 来源
     */
    @Column(name = "ALE_SOURCE", length = 256)
    private String source;

    /**
     * 摘要
     */
    @Column(name = "ALE_ADS", length = 1000)
    private String ads;

    /**
     * 关键字
     */
    @Column(name = "ALE_KEYWORD", length = 500)
    private String keyWord;

    /**
     * 类型
     */
    @Column(name = "ALE_TYPE", length = 100)
    private String type;

    /**
     * 标题图
     */
    @Column(name = "ALE_PICTURE", length = 500)
    private String picture;

    /**
     * 正文
     */
    @Column(name = "ALE_CONTENT", columnDefinition = "mediumtext")
    private String content;

    /**
     * 点击量
     */
    @Column(name = "ALE_CLICK", length = 100)
    private String click;

    /**
     * 信息置顶
     */
    @Column(name = "ALE_IS_TOP", columnDefinition = "int", length = 11)
    private Integer isTOP;
    /**
     * 来源方式
     */
    @Column(name = "ALE_MODE", columnDefinition = "int", length = 11)
    private Integer mode;

    /**
     * 浏览量
     */
    @Column(name = "ALE_BROWSE", length = 100)
    private String browse;


    public Article replaceChUUID(String chUUID) {
        this.chUUID = chUUID;
        return this;
    }

    public Article replaceContent(String newContent) {
        this.content = newContent;
        return this;
    }
}
