package com.example.sqlserver.collector.entity.local;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/18 14:26
 * <p>@author : C
 * 栏目
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "dc_channel")
public class Channel {
    @Id
    @Column(name = "CAL_UUID", length = 48, nullable = false)
    private String uuid;

    @Column(name = "CAL_CREATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date createDate;

    @Column(name = "CAL_UPDATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date updateDate;

    @Column(name = "CAL_SUPER_UUID", length = 48)
    private String superUUID;

    @Column(name = "CAL_NAME", length = 128)
    private String name;

    @Column(name = "CAL_INTRODUCE", columnDefinition = "text")
    private String introduce;

    @Column(name = "CAL_ORDER", columnDefinition = "int", length = 11, nullable = false)
    private Integer order;


    public Channel setSuperUUID(String superUUID) {
        this.superUUID = superUUID;
        return this;
    }

    public Channel replaceSuperUUID(String uuid) {
        this.superUUID = superUUID;
        return this;
    }
}
