package com.example.sqlserver.collector.service.helper;

import com.example.sqlserver.collector.entity.local.Article;
import com.example.sqlserver.collector.entity.local.Annex;
import com.example.sqlserver.collector.entity.local.Channel;
import com.example.sqlserver.collector.entity.remote.RemoteArticle;
import com.example.sqlserver.collector.entity.remote.RemoteArticleInfo;
import com.example.sqlserver.collector.entity.remote.RemoteChannel;
import com.example.sqlserver.collector.repository.remote.RemoteArticleInfoRepository;
import com.example.sqlserver.collector.repository.remote.RemoteArticleRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/18 14:15
 * <p>@author : C
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Slf4j
@Service
public class TransHelper {

    @Autowired
    ContentParseHelper contentParseHelper;
    @Autowired
    RemoteArticleRepository remoteArticleRepository;
    @Autowired
    RemoteArticleInfoRepository remoteArticleInfoRepository;
    @Value("${oss.prefix}")
    String prefix;

    public Boolean infoExists(RemoteArticle remoteArticle) {
        return remoteArticleInfoRepository.exists(remoteArticle.getId());
    }

    public Article toArticle(RemoteArticle remoteArticle) {
        RemoteArticleInfo remoteArticleInfo = remoteArticleInfoRepository.findOne(remoteArticle.getId());
        return new Article(
                newId(),
                new Date(),
                new Date(),
                remoteArticleInfo.getChId(),
                remoteArticle.getTitle(),
                remoteArticleInfo.getPubTime(),
                remoteArticleInfo.getOrderTime(),
                remoteArticleInfo.getExamineTime(),
                remoteArticle.getAuthor(),
                remoteArticle.getSource(),
                remoteArticle.getAds(),
                remoteArticle.getKeyWord(),
                getTypeString(remoteArticleInfo.getType()),
                contentParseHelper.parseTitlePicFromContent(remoteArticle.getContent()),
                remoteArticle.getContent(),
                remoteArticleInfo.getClick().toString(),
                remoteArticleInfo.getOnTop(),
                remoteArticleInfo.getCatchMode(),
                remoteArticleInfo.getClick().toString()
        );
    }

    public Article toArticle(RemoteArticleInfo remoteArticleInfo) {
        RemoteArticle remoteArticle = remoteArticleRepository.findOne(remoteArticleInfo.getId());
        return new Article(
                newId(),
                new Date(),
                new Date(),
                remoteArticleInfo.getChId(),
                remoteArticle.getTitle(),
                remoteArticleInfo.getPubTime(),
                remoteArticleInfo.getOrderTime(),
                remoteArticleInfo.getExamineTime(),
                remoteArticle.getAuthor(),
                remoteArticle.getSource(),
                remoteArticle.getAds(),
                remoteArticle.getKeyWord(),
                remoteArticleInfo.getType().toString(),
                contentParseHelper.parseTitlePicFromContent(remoteArticle.getContent()),
                remoteArticle.getContent(),
                remoteArticleInfo.getClick().toString(),
                remoteArticleInfo.getOnTop(),
                remoteArticleInfo.getCatchMode(),
                remoteArticleInfo.getClick().toString()
        );
    }

    public Channel toChannel(RemoteChannel remoteChannel) {
        return new Channel(
                newId(),
                new Date(),
                new Date(),
                "",
                remoteChannel.getName(),
                remoteChannel.getIntroduce(),
                remoteChannel.getOrder()
        );
    }

    public Stream<Annex> toAnnexStream(Article article) {
        List<String> paths = contentParseHelper.getPaths(article.getContent());
        List<Annex> result = paths.stream()
                .map(path -> new Annex(
                        newId(),
                        new Date(),
                        new Date(),
                        article.getUuid(),
                        article.getTitle(),
                        path,
                        article.getAds()
                ))
                .collect(Collectors.toList());
        return result.stream();
    }

    public Stream<String> toPathStream(Article article) {
        List<String> paths = contentParseHelper.getPaths(article.getContent());
        return paths.stream();
    }

    public Article replaceContent(Article article) {
        String newContent = contentParseHelper.replacePaths(article.getContent());
        newContent = contentParseHelper.replaceRepeatedPaths(newContent);
        return article.replaceContent(newContent);
    }

    public Annex replacePath(Annex annex) {
        String newPath = contentParseHelper.replacePath(annex.getPath());
        return annex.replacePath(newPath);
    }

    public String getFileName(String path) {
        int index = path.lastIndexOf("/");
        return path.substring(index + 1);
    }

    private String getTypeString(Integer type) {
        if (Objects.equals(type, 0)) {
            return "文章";
        } else if (Objects.equals(type, 1)) {
            return "图文";
        } else {
            return "";
        }
    }

    private String newId(){
        return UUID.randomUUID().toString();
    }
}
