package com.example.sqlserver.collector.task;

import com.example.sqlserver.collector.service.Updater;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <p>Description : sqlserver-collector
 * <p>Date : 2019/8/2 9:21
 * <p>@author : C
 */
@Setter
@Component
public class Tasks {

    private final
    Updater updater;

    @Autowired
    public Tasks(Updater updater) {
        this.updater = updater;
    }

    private Boolean isRunning = true;
    /**
     * 更新全部
     */
    @Scheduled(initialDelay = 0, fixedRate = 60000 * 30)
    public void updateAll() {
        if (isRunning){
            updater.updateAll();
        }
    }

    /**
     * 将需要更新的文章放入待更新缓存
     */
//    @Scheduled(initialDelay = 0, fixedRate = 60000 * 1)
    public void getRemoteArticlesForSave() {
        if (isRunning){
            updater.getRemoteArticlesForSave();
        }
    }

    /**
     * 将需要更新的栏目放入待更新缓存
     */
//    @Scheduled(initialDelay = 0, fixedRate = 60000 * 1)
    public void getRemoteTopicsForSave() {
        if (isRunning){
            updater.getRemoteChannelsForSave();
        }
    }

    /**
     * 更新保存文章
     * 并将其内容中包含的附件放入待更新缓存
     * 具备替换路径逻辑
     * 一次从缓存中取100条来更新
     */
//    @Scheduled(initialDelay = 10000, fixedRate = 60000*1)
    public void updateArticleAndAttachment() {
        if (isRunning) {
            updater.updateArticlesAndAnnexes(1000);
        }
    }

    /**
     * 更新保存栏目
     * 一次从缓存中取100条来更新
     */
//    @Scheduled(initialDelay = 30000, fixedRate = 60000*1)
    public void updateTopic() {
        if (isRunning) {
            updater.updateChannels(1000);
        }
    }

    /**
     * 更新保存附件
     * 具备替换路径逻辑
     * 一次从缓存中取100条来更新
     */
//    @Scheduled(initialDelay = 10000, fixedRate = 60000*10)
    public void uploadFile() {
        if (isRunning){
            updater.uploadFile(1000);
        }
    }

}
