package com.example.sqlserver.collector;

import com.example.sqlserver.collector.entity.local.Article;
import com.example.sqlserver.collector.repository.local.AnnexRepository;
import com.example.sqlserver.collector.repository.local.ArticleRepository;
import com.example.sqlserver.collector.repository.local.ChannelRepository;
import com.example.sqlserver.collector.repository.remote.RemoteArticleInfoRepository;
import com.example.sqlserver.collector.repository.remote.RemoteArticleRepository;
import com.example.sqlserver.collector.repository.remote.RemoteChannelRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;
import sun.util.resources.ga.LocaleNames_ga;

import java.util.Comparator;

/**
 * @author C
 */
@Slf4j
@EnableScheduling
@SpringBootApplication
public class SqlserverTestApplication implements CommandLineRunner {

    @Autowired
    RemoteArticleRepository remoteArticleRepository;

    @Autowired
    RemoteArticleInfoRepository remoteArticleInfoRepository;

    @Autowired
    RemoteChannelRepository remoteChannelRepository;

    @Autowired
    ArticleRepository articleRepository;
    @Autowired
    AnnexRepository annexRepository;
    @Autowired
    ChannelRepository channelRepository;

    public static void main(String[] args) {
        SpringApplication.run(SqlserverTestApplication.class, args);
    }

    @Override
    public void run(String... args) throws Exception {
        long lmgl = remoteChannelRepository.count();
        long xxgl_lm = remoteArticleInfoRepository.count();
        long xxgl = remoteArticleRepository.count();
        long total = xxgl + xxgl_lm + lmgl;
        System.out.println("xxgl : " + xxgl);
        System.out.println("xxgl_lm : " + xxgl_lm);
        System.out.println("lmgl : " + lmgl);
        System.out.println("total : " + total);
    }
}
