package com.example.sqlserver.collector.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

/**
 * @author C
 */
@ComponentScan
@Configuration
public class DataSourceConfig {

    /**
     * 本地数据源 MySQL
     * 用于存储和提供
     * 数据仓库
     */
    @Bean(name = "localDataSource")
    @Qualifier("localDataSource")
    @Primary
    @ConfigurationProperties(prefix = "spring.datasource.local")
    public DataSource localDataSource() {
        return DataSourceBuilder.create().build();
    }

    /**
     * 对方数据源
     * SQL Server 2008
     * 用于采集
     */
    @Bean(name = "remoteDataSource")
    @Qualifier("remoteDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.remote")
    public DataSource remoteDataSource() {
        return DataSourceBuilder.create().build();
    }

}
