package com.example.sqlserver.collector.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryRemote",
        transactionManagerRef = "transactionManagerRemote",
        basePackages = {"com.example.sqlserver.collector.repository.remote"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class RemoteConfig {

    @Autowired
    @Qualifier("remoteDataSource")
    private DataSource remoteDataSource;

    @Bean(name = "entityManageRemote")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryRemote(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryRemote")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryRemote(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource)
                .properties(getVendorProperties(remoteDataSource))
                .packages("com.example.sqlserver.collector.entity.remote")
                .persistenceUnit("remotePersistenceUnit")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;

    private Map<String, String> getVendorProperties(DataSource dataSource) {
        return jpaProperties.getHibernateProperties(dataSource);
    }

    @Bean(name = "transactionManagerRemote")
    public PlatformTransactionManager transactionManagerRemote(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryRemote(builder).getObject());
    }
}
