package com.example.sqlserver.collector.controller;

import com.example.sqlserver.collector.entity.local.Annex;
import com.example.sqlserver.collector.repository.local.AnnexRepository;
import com.example.sqlserver.collector.task.Tasks;
import javafx.scene.media.VideoTrack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Description : sqlserver-collector
 * <p>Date : 2019/8/27 15:32
 * <p>@author : C
 */
@RestController
public class CollectorController {

    private final
    Tasks tasks;

    private final
    AnnexRepository annexRepository;

    @Autowired
    public CollectorController(Tasks tasks, AnnexRepository annexRepository) {
        this.tasks = tasks;
        this.annexRepository = annexRepository;
    }

    @GetMapping("/start")
    public ResponseEntity<String> start(){
        tasks.setIsRunning(true);
        return new ResponseEntity<>("start successful", HttpStatus.OK);
    }

    @GetMapping("/close")
    public ResponseEntity<String> close(){
        tasks.setIsRunning(false);
        return new ResponseEntity<>("close successful", HttpStatus.OK);
    }

    @GetMapping("/files")
    public ResponseEntity<List<String>> files(){
        List<String> result = annexRepository.findAll().stream()
                .map(Annex::getPath)
                .filter(path -> path.startsWith("file:///"))
                .collect(Collectors.toList());
        return new ResponseEntity<>(result , HttpStatus.OK);
    }
}
