package com.example.sqlserver.collector.entity.local;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/24 14:12
 * <p>@author : C
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "dc_annex")
public class Annex {
    @Id
    @Column(name = "ANX_UUID", length = 48)
    private String uuid;

    @Column(name = "ANX_CREATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date createDate;

    @Column(name = "ANX_UPDATE_DATE", columnDefinition = "timestamp", nullable = false)
    private Date updateDate;

    @Column(name = "ANX_UUID_OLD", length = 48)
    private String articleUUID;

    @Column(name = "ANX_TITLE", length = 100)
    private String title;

    @Column(name = "ANX_PATH", length = 500)
    private String path;

    @Column(name = "ANX_ADS", length = 1000)
    private String ads;

    public Annex replacePath(String newPath) {
        this.path = newPath;
        return this;
    }
}
