package com.example.sqlserver.collector.entity.remote;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/15 14:50
 * <p>@author : C
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "dbo.xxgl_lm")
public class RemoteArticleInfo {

    @Id
    @Column(name = "xxid")
    private Integer id;

    /**
     * 栏目编号
     */
    @Column(name  = "lmbh")
    private String chId;

    /**
     * 点击量
     */
    @Column(name  = "djs")
    private Integer click;

    /**
     * 提交时间
     */
    @Column(name = "tjsj")
    private Date orderTime;

    /**
     * 审核时间
     */
    @Column(name = "shsj")
    private Date examineTime;

    /**
     * 生成静态页面时间
     */
    @Column(name = "scjtymsj")
    private Date pubTime;

    /**
     * 类型：图文 文章
     */
    @Column(name = "sfscjtym")
    private Integer type;

    /**
     * 来源方式（0是转载 1是撰写）
     */
    @Column(name = "lyfs")
    private Integer catchMode;

    /**
     * 信息置顶
     */
    @Column(name = "xxzd")
    private Integer onTop;
}
