package com.example.sqlserver.collector.service.helper;

import com.example.sqlserver.collector.entity.local.Annex;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>Description : sqlserver-test
 * <p>Date : 2019/7/23 9:53
 * <p>@author : C
 */
@SuppressWarnings({"Duplicates", "SpringAutowiredFieldsWarningInspection"})
@Service
public class ContentParseHelper {

    @Value("${oss.prefix}")
    String prefix;

    @Autowired
    ContentParseHelper contentParseHelper;


    public List<String> parseSrcPathsFromContent(String content) {
        List<String> result = Lists.newArrayList();
        int index = 0;
        while (index < content.length()) {
            int start = content.indexOf("src=\"", index);
            if (start > 0) {
                index = start + 1;
                int firstQuote = content.indexOf("\"", start);
                int secondQuote = content.indexOf("\"", firstQuote + 1);
                String firstResult = content.substring(start, secondQuote + 1);
                firstQuote = firstResult.indexOf("\"");
                secondQuote = firstResult.indexOf("\"", firstQuote + 1);
                result.add(firstResult.substring(firstQuote + 1, secondQuote));
            } else {
                break;
            }
        }
        return result;
    }

    public List<String> parseHrefPathsFromContent(String content) {
        List<String> result = Lists.newArrayList();
        int index = 0;
        while (index < content.length()) {
            int start = content.indexOf("href=\"", index);
            if (start > 0) {
                index = start + 1;
                int firstQuote = content.indexOf("\"", start);
                int secondQuote = content.indexOf("\"", firstQuote + 1);
                String firstResult = content.substring(start, secondQuote + 1);
                firstQuote = firstResult.indexOf("\"");
                secondQuote = firstResult.indexOf("\"", firstQuote + 1);
                result.add(firstResult.substring(firstQuote + 1, secondQuote));
            } else {
                break;
            }
        }
        return result;
    }

    public String parseTitlePicFromContent(String content) {
        List<String> results = parseSrcPathsFromContent(content);
        String result = "";
        if (!results.isEmpty()) {
            if (contentParseHelper.pathIsPic(results.get(0))) {
                result = results.get(0);
            }
        }
        return result;
    }

    public List<String> getPaths(String content) {
        List<String> srcPaths = parseSrcPathsFromContent(content);
        List<String> hrefPaths = parseHrefPathsFromContent(content);
        List<String> paths = Lists.newArrayList();
        paths.addAll(srcPaths);
        paths.addAll(hrefPaths);
        return paths;
    }

    public String replacePaths(String content) {
        String newContent = content;
        List<String> paths = getPaths(content);
        for (String path : paths) {
            if (pathIsFile(path) && path.startsWith("/")) {
                newContent = newContent.replace(path, replacePath(path));
            }
        }
        return newContent;
    }

    public String replaceRepeatedPaths(String content) {
        String newContent = content;
        List<String> paths = getPaths(content);
        for (String path : paths) {
            if (path.startsWith(prefix + prefix)) {
                newContent = newContent.replaceAll(prefix + prefix, prefix);
            }
        }
        return newContent;
    }

    public Boolean isFile(Annex annex) {
        return pathIsFile(annex.getPath());
    }

    public Boolean isPic(Annex annex) {
        return pathIsPic(annex.getPath());
    }

    public Boolean pathIsFile(String path) {
        int formatIndex = path.lastIndexOf(".");
        if (formatIndex > 0) {
            String format = path.substring(formatIndex);
            return Objects.equals(".jpg", format) ||
                    Objects.equals(".png", format) ||
                    Objects.equals(".bmp", format) ||
                    Objects.equals(".xls", format) ||
                    Objects.equals(".doc", format) ||
                    Objects.equals(".gif", format) ||
                    Objects.equals(".pdf", format);
        }
        return false;
    }

    public Boolean pathIsPic(String path) {
        int formatIndex = path.lastIndexOf(".");
        if (formatIndex > 0) {
            String format = path.substring(formatIndex);
            return Objects.equals(".jpg", format) ||
                    Objects.equals(".png", format) ||
                    Objects.equals(".bmp", format);
        }
        return false;
    }

    public String replacePath(String path) {
        if (path.startsWith(prefix)) {
            return path;
        } else {
            return prefix + path;
        }
    }

    public String restorePath(String path) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        } else {
            return path;
        }
    }

    public int kmp(String source, String target) {
        char[] sourceArr = source.toCharArray();
        char[] targetArr = target.toCharArray();
        int[] fixTable = getFixTable(target);
        int index = 0;
        while (index < sourceArr.length - targetArr.length) {
            boolean match = true;
            for (int i = 0; i < targetArr.length; i++) {
                if (sourceArr[i + index] != targetArr[i]) {
                    match = false;
                    index = index + i - fixTable[i];
                    break;
                }
            }
            if (match) {
                return index;
            }
        }
        return -1;
    }

    private int[] getFixTable(String target) {
        int size = target.length();
        int[] fixTable = new int[size];
        for (int i = 0; i < fixTable.length; i++) {
            if (i == 0) {
                fixTable[i] = -1;
            } else if (i == 1) {
                fixTable[i] = 0;
            } else {
                int fixLength = 0;
                //a b a b c
                for (int j = 0; j < i - 1; j++) {
                    if (Objects.equals(target.substring(0, j + 1), target.substring(i - j - 1, i))) {
                        fixLength = j + 1;
                    }
                }
                fixTable[i] = fixLength;
            }
        }
        return fixTable;
    }
}
