package com.example.sqlserver.collector.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.*;
import org.springframework.stereotype.Component;

import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * oss 文件存储系统工具类
 *
 * @author mcj
 */
@Component
public class OssUtil {

    private OSSClient ossClient;

    {
        String endpoint = "http://oss-cn-hangzhou.aliyuncs.com";
// 阿里云主账号AccessKey拥有所有API的访问权限，风险很高。强烈建议您创建并使用RAM账号进行API访问或日常运维，请登录 https://ram.console.aliyun.com 创建RAM账号。
        String accessKeyId = "LTAIu1wBaQJ9NkM9";
        String accessKeySecret = "xzxlmm43htGZkK71ufefolIgSNE7Xt";
        String bucketName = "mcjtest1";
// 创建OSSClient实例。
        ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
    }

    /**
     * 获取所有存储空间名称
     *
     * @return list<string>
     */
    public List<String> getBucket() {
        List<Bucket> buckets = ossClient.listBuckets();
        return buckets.stream()
                .map(Bucket::getName)
                .collect(Collectors.toList());
    }

    /**
     * 对文件大小做分析
     */
    public void upload() {

    }

    /**
     * 普通上传文件推荐不要大于5g
     *
     * @param bucketName  存储空间名称
     * @param fileName    文件名称
     * @param inputStream 流
     * @return true or false 代表上传成功失败
     */
    public boolean uploadFile(String bucketName, String fileName, InputStream inputStream) {
        try {
            ossClient.putObject(bucketName, fileName, inputStream);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }


    /**
     * 分片上传
     *
     * @param bucketName  存储空间名称
     * @param fileName    文件名称
     * @param inputStream 文件流
     */
    public void multipartupload(String bucketName, String fileName, InputStream inputStream) {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, fileName);
        InitiateMultipartUploadResult result = ossClient.initiateMultipartUpload(request);
        // 返回uploadId，它是分片上传事件的唯一标识，您可以根据这个ID来发起相关的操作，如取消分片上传、查询分片上传等。
        String uploadId = result.getUploadId();

        // partETags是PartETag的集合。PartETag由分片的ETag和分片号组成。
        List<PartETag> partETags = new ArrayList<PartETag>();
        // 计算文件有多少个分片。
        final long partSize = 1 * 1024 * 1024L;
        final File sampleFile = new File("<localFile>");
        long fileLength = sampleFile.length();
        int partCount = (int) (fileLength / partSize);
        if (fileLength % partSize != 0) {
            partCount++;
        }


        for (int i = 0; i < partCount; i++) {
            long startPos = i * partSize;
            long curPartSize = (i + 1 == partCount) ? (fileLength - startPos) : partSize;
            // 跳过已经上传的分片。
            try {
                inputStream.skip(startPos);
            } catch (IOException e) {
                e.printStackTrace();
            }
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(bucketName);
            uploadPartRequest.setKey(fileName);
            uploadPartRequest.setUploadId(uploadId);
            uploadPartRequest.setInputStream(inputStream);
            // 设置分片大小。除了最后一个分片没有大小限制，其他的分片最小为100KB。
            uploadPartRequest.setPartSize(curPartSize);
            // 设置分片号。每一个上传的分片都有一个分片号，取值范围是1~10000，如果超出这个范围，OSS将返回InvalidArgument的错误码。
            uploadPartRequest.setPartNumber(i + 1);
            // 每个分片不需要按顺序上传，甚至可以在不同客户端上传，OSS会按照分片号排序组成完整的文件。
            UploadPartResult uploadPartResult = ossClient.uploadPart(uploadPartRequest);
            // 每次上传分片之后，OSS的返回结果会包含一个PartETag。PartETag将被保存到partETags中。
            partETags.add(uploadPartResult.getPartETag());
        }

        Collections.sort(partETags, Comparator.comparingInt(PartETag::getPartNumber));

        // 在执行该操作时，需要提供所有有效的partETags。OSS收到提交的partETags后，会逐一验证每个分片的有效性。当所有的数据分片验证通过后，OSS将把这些分片组合成一个完整的文件。
        CompleteMultipartUploadRequest completeMultipartUploadRequest =
                new CompleteMultipartUploadRequest(bucketName, fileName, uploadId, partETags);
        ossClient.completeMultipartUpload(completeMultipartUploadRequest);
    }

    /**
     * 断点上传
     */
    public void checkpointUpload(String bucketName, String fileName, InputStream inputStream) {
        // 通过UploadFileRequest设置多个参数。
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, fileName);
        // 通过UploadFileRequest设置单个参数。
        // 设置存储空间名称。
        uploadFileRequest.setBucketName(bucketName);
        // 设置文件名称。
        uploadFileRequest.setKey(fileName);
        // 指定上传的本地文件。
        File file = new File("files");
        try {
            file.mkdirs();
            byte[] bytes = new byte[1024 * 1024];
            int len = 0;
            FileOutputStream fileOutputStream = new FileOutputStream(file + "/" + fileName);
            while ((len = inputStream.read(bytes)) != -1) {
                fileOutputStream.write(bytes, 0, len);
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException ignored) {

        }

        uploadFileRequest.setUploadFile("files/" + fileName);
        // 指定上传并发线程数，默认为1。
        uploadFileRequest.setTaskNum(5);
        // 指定上传的分片大小，范围为100KB~5GB，默认为文件大小/10000。
        // 开启断点续传，默认关闭。
        uploadFileRequest.setEnableCheckpoint(true);
        // 记录本地分片上传结果的文件。开启断点续传功能时需要设置此参数，上传过程中的进度信息会保存在该文件中，如果某一分片上传失败，再次上传时会根据文件中记录的点继续上传。上传完成后，该文件会被删除。默认与待上传的本地文件同目录，为uploadFile.ucp。
        // 设置上传成功回调，参数为Callback类型。

        // 断点续传上传。
        try {
            ossClient.uploadFile(uploadFileRequest);
            File file1 = new File("files/" + fileName);
            System.out.println(file1.getName());
            file1.delete();
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }


    public void initClient() {

    }

    public void shotdownClient() {

    }
}
