package com.example.morsecoder.controller;

import com.example.morsecoder.MorseCoder;
import com.example.morsecoder.entity.CodeRequest;
import com.example.morsecoder.entity.CodeResponse;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RequestMapping("/morse")
@RestController
public class MorseController {

    @Autowired
    private MorseCoder morseCoder;

    @ApiOperation("加密")
    @PostMapping("/encode")
    public ResponseEntity<CodeResponse> encode(@RequestBody CodeRequest request) {
        String result = morseCoder.encode(request.getCode());
        return ResponseEntity.ok(new CodeResponse(result));
    }

    @ApiOperation("解密")
    @PostMapping("/decode")
    public ResponseEntity<CodeResponse> decode(@RequestBody CodeRequest request) {
        String result = morseCoder.encode(request.getCode());
        return ResponseEntity.ok(new CodeResponse(result));
    }

    @GetMapping("/test")
    public ResponseEntity<String> asserts() {
        log.info("Test");
        return ResponseEntity.ok("Hello Test");
    }

}
