package com.example.datasending;

import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;

public class App extends Application {

    @Override
    public void start(Stage primaryStage) {
        primaryStage.setTitle("Real-time Chart");

        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setLabel("Time (HH:mm:ss)");
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("sc");

        LineChart<String, Number> lineChart = new LineChart<>(xAxis, yAxis);

        XYChart.Series<String, Number> fgSeries = new XYChart.Series<>();
        fgSeries.setName("FG");
        lineChart.getData().add(fgSeries);

        XYChart.Series<String, Number> dsmSeries = new XYChart.Series<>();
        dsmSeries.setName("DSM");
        lineChart.getData().add(dsmSeries);

        Button startButton = new Button("Start");
        Button stopButton = new Button("Stop");
        TextField freqTextField = new TextField("5");
        freqTextField.setPromptText("Freq (s)");

        VBox vbox = new VBox(10, startButton, stopButton, freqTextField, lineChart);
        primaryStage.setScene(new Scene(vbox, 800, 600));
        primaryStage.show();

        long[] lastUpdate = {0};
        long[] interval = {5_000_000_000L};

        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

        AnimationTimer timer = new AnimationTimer() {
            @Override
            public void handle(long now) {
                if (now - lastUpdate[0] >= interval[0]) {
                    lastUpdate[0] = now;
                    String currentTime = sdf.format(new Date());

                    try {
                        JSONObject jsonObject = fetchData();
                        JSONArray rankList = jsonObject.getJSONArray("rankList");

                        for (int i = 0; i < rankList.length(); i++) {
                            JSONObject dataObject = rankList.getJSONObject(i);
                            int rid = dataObject.getInt("rid");
                            int sc = dataObject.getInt("sc");

                            if (rid == 9999) {
                                fgSeries.getData().add(new XYChart.Data<>(currentTime, sc));
                            } else if (rid == 606118) {
                                dsmSeries.getData().add(new XYChart.Data<>(currentTime, sc));
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };

        startButton.setOnAction(event -> {
            interval[0] = (long) (Double.parseDouble(freqTextField.getText()) * 1_000_000_000L);
            timer.start();
        });

        stopButton.setOnAction(event -> timer.stop());
    }

    private JSONObject fetchData() throws IOException {
        String apiUrl = "http://43.138.103.253:9999/test";
        try (InputStream is = new URL(apiUrl).openStream();
             Scanner scanner = new Scanner(is, "UTF-8")) {
            String jsonText = scanner.useDelimiter("\\A").next();
            JSONObject jsonObject = new JSONObject(jsonText);
            return jsonObject.getJSONObject("data").getJSONObject("data");
        }
    }

    public static void main(String[] args) {
        launch();
    }
}



