package com.example.datasending;

import cn.hutool.core.util.RandomUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

@NoArgsConstructor
@Data
@AllArgsConstructor
public class TerminalData {


    @JsonProperty("hardware_detection")
    private HardwareDetectionDTO hardwareDetection;
    @JsonProperty("task_manager")
    private TaskManagerDTO taskManager;

    //初始化终端发送数据
    public TerminalData initTerminalData() {
        this.hardwareDetection = new HardwareDetectionDTO().initHardware();
        this.taskManager = new TaskManagerDTO().initTask();
        return this;
    }

    public TerminalData initTerminalData1() {
        this.hardwareDetection = new HardwareDetectionDTO().initHardware1();
        this.taskManager = new TaskManagerDTO().initTask();
        return this;
    }

    @NoArgsConstructor
    @Data
    @AllArgsConstructor
    public static class HardwareDetectionDTO {
        @JsonProperty("computer_model")
        private String computerModel;
        @JsonProperty("operating_system")
        private String operatingSystem;
        @JsonProperty("computer_manufacture")
        private String computerManufacture;
        @JsonProperty("cpu_model")
        private String cpuModel;
        @JsonProperty("computer_base_board_model")
        private String computerBaseBoardModel;
        @JsonProperty("bios_model")
        private String biosModel;
        @JsonProperty("uuid")
        private String uuid;
        @JsonProperty("agent")
        private AgentDTO agent;

        // 初始化内容合理的硬件主板信息
        public HardwareDetectionDTO initHardware() {
            this.computerModel = "ThinkPad T480";
            this.operatingSystem = "Windows 10";
            this.computerManufacture = "Lenovo";
            this.cpuModel = "Intel(R) Core(TM) i5-8250U CPU @ 1.60GHz";
            this.computerBaseBoardModel = "20L5CTO1WW";
            this.biosModel = "LENOVO N2JET45W (1.29 )";
            this.uuid = "B4D27E1F-2E6A-11EB-9B1D-AC1F6B0D9C0D";
            this.agent = new AgentDTO().initAgent();
            return this;
        }

        public HardwareDetectionDTO initHardware1() {
            HardwareDetectionDTO mockData = new HardwareDetectionDTO();
            mockData.setComputerModel("MacBook Pro");
            mockData.setOperatingSystem("macOS Big Sur");
            mockData.setComputerManufacture("Apple");
            mockData.setCpuModel("Intel Core i7");
            mockData.setComputerBaseBoardModel("Mac-9AE82516C7C6B903");
            mockData.setBiosModel("MBA81.88Z.0167.B00.2008272126");
            mockData.setUuid("6ED07C24-893D-4423-AE11-45670DE54321");
            mockData.setAgent(new AgentDTO().initAgent1());
            return mockData;
        }


        @NoArgsConstructor
        @Data
        @AllArgsConstructor
        public static class AgentDTO {
            @JsonProperty("id")
            private String id;
            @JsonProperty("type")
            private String type;
            @JsonProperty("start_time")
            private String startTime;
            @JsonProperty("version")
            private String version;
            @JsonProperty("mac_address")
            private String macAddress;
            @JsonProperty("ipv4_address")
            private String ipv4Address;

            //初始化Agent对象
            public AgentDTO initAgent() {
                this.id = RandomUtil.randomString(10);
                this.type = "server";
                this.startTime = "2020-12-01 00:00:00";
                this.version = "1.0.0";
                this.macAddress = "08:00:20:0A:8C:6D";
                this.ipv4Address = "192.168.55.55";
                return this;
            }

            public AgentDTO initAgent1() {
                AgentDTO mockData = new AgentDTO();
                mockData.setId(RandomUtil.randomString(10));
                mockData.setType("server");
                mockData.setStartTime("2022-01-01 00:00:00");
                mockData.setVersion("2.0.0");
                mockData.setMacAddress("1A:2B:3C:4D:5E:6F");
                mockData.setIpv4Address("192.168.100.100");
                return mockData;
            }


        }
    }

    @NoArgsConstructor
    @Data
    @AllArgsConstructor
    public static class TaskManagerDTO {
        @JsonProperty("process")
        private ProcessDTO process;
        @JsonProperty("performance")
        private PerformanceDTO performance;

        //初始化Task对象,使用子对象的初始化方法
        public TaskManagerDTO initTask() {
            this.process = new ProcessDTO().initProcess();
            this.performance = new PerformanceDTO().initPerformance();
            return this;
        }

        @NoArgsConstructor
        @Data
        @AllArgsConstructor
        public static class ProcessDTO {
            @JsonProperty("process_number")
            private Integer processNumber;

            //初始化处理器数量 4核
            public ProcessDTO initProcess() {
                this.processNumber = 4;
                return this;
            }
        }

        @NoArgsConstructor
        @Data
        @AllArgsConstructor
        public static class PerformanceDTO {
            @JsonProperty("cpu")
            private CpuDTO cpu;
            @JsonProperty("ram")
            private RamDTO ram;
            @JsonProperty("disk")
            private DiskDTO disk;
            @JsonProperty("net_card")
            private NetCardDTO netCard;

            //初始化性能数值，使用子对象的初始化方法
            public PerformanceDTO initPerformance() {
                this.cpu = new CpuDTO().initCpu();
                this.ram = new RamDTO().initRam();
                this.disk = new DiskDTO().initDisk();
                this.netCard = new NetCardDTO().initNetCard();
                return this;
            }

            @NoArgsConstructor
            @Data
            @AllArgsConstructor
            public static class CpuDTO {
                @JsonProperty("cpu_usage")
                private Integer cpuUsage;
                @JsonProperty("cpu_per_usage")
                private List<Double> cpuPerUsage;

                //初始化合理数值的cpu使用率数据
                public CpuDTO initCpu() {
                    this.cpuUsage = RandomUtil.randomInt(50, 90);
                    this.cpuPerUsage = new ArrayList<>();
                    for (int i = 0; i < 4; i++) {
                        this.cpuPerUsage.add(RandomUtil.randomDouble(50, 90, RoundingMode.CEILING));
                    }
                    return this;
                }
            }

            @NoArgsConstructor
            @Data
            @AllArgsConstructor
            public static class RamDTO {
                @JsonProperty("ram_usage")
                private Integer ramUsage;
                @JsonProperty("ram_total")
                private String ramTotal;
                @JsonProperty("ram_used")
                private String ramUsed;
                @JsonProperty("ram_free")
                private String ramFree;

                //初始化合理数值的内存数据 单位是MB
                public RamDTO initRam() {
                    this.ramTotal = RandomUtil.randomInt(100_000, 200_000) + "MB";
                    this.ramUsed = RandomUtil.randomInt(50_000, 100_000) + "MB";
                    this.ramFree = RandomUtil.randomInt(10_000, 50_000) + "MB";
                    this.ramUsage = RandomUtil.randomInt(50, 90);
                    return this;
                }
            }

            @NoArgsConstructor
            @Data
            @AllArgsConstructor
            public static class DiskDTO {
                @JsonProperty("disk_usage")
                private Double diskUsage;
                @JsonProperty("disk_total")
                private String diskTotal;
                @JsonProperty("disk_used")
                private String diskUsed;
                @JsonProperty("disk_free")
                private String diskFree;

                //初始化磁盘数据 单位是MB 数值要合理
                public DiskDTO initDisk() {
                    this.diskTotal = RandomUtil.randomInt(100_000, 200_000) + "MB";
                    this.diskUsed = RandomUtil.randomInt(50_000, 100_000) + "MB";
                    this.diskFree = RandomUtil.randomInt(10_000, 50_000) + "MB";
                    this.diskUsage = RandomUtil.randomDouble(0.5, 0.9);
                    return this;
                }
            }

            @NoArgsConstructor
            @Data
            @AllArgsConstructor
            public static class NetCardDTO {
                @JsonProperty("net_card_flow_in")
                private Long netCardFlowIn;
                @JsonProperty("net_card_flow_out")
                private Long netCardFlowOut;

                //初始化流量数据
                public NetCardDTO initNetCard() {
                    this.netCardFlowIn = RandomUtil.randomLong(100_000L, 1_000_000L);
                    this.netCardFlowOut = RandomUtil.randomLong(1_000_000L, 2_000_000L);
                    return this;
                }
            }
        }
    }
}