package com.example.datasending.collectors;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Slf4j
@Service
public class DataCollector {

    @Resource
    private DataRecordService dataRecordService;

    public void collectData() {

        JSONObject jsonObject = JSONUtil.parseObj(HttpUtil.get("http://43.138.103.253:9999/test"));
        JSONArray rankList = jsonObject.getJSONObject("data").getJSONObject("data").getJSONArray("rankList");

        for (int i = 0; i < rankList.size(); i++) {
            JSONObject dataObject = rankList.getJSONObject(i);
            int rid = dataObject.getInt("rid");
            int sc = dataObject.getInt("sc");

            if (rid == 9999 || rid == 606118) {
                DataRecord dataRecord = new DataRecord();
                dataRecord.setRid(rid);
                dataRecord.setSc(sc);
                dataRecord.setTimestamp(new Date());
                log.info("[采集数据] {}", dataRecord);

                dataRecordService.save(dataRecord);
            }
        }
    }
}

