package com.example.datasending;

import static io.github.cweijan.mock.Mocker.*;

import io.github.cweijan.mock.Asserter;
import io.github.cweijan.mock.jupiter.HttpTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.springframework.http.ResponseEntity;

import javax.annotation.Resource;

@HttpTest
class ApplicationControllerTest {

    @Resource
    private ApplicationController applicationController;


    @Test
    @EnabledOnOs({OS.WINDOWS, OS.MAC})
    void startTask() {
        String string = mock(String.class);
        ResponseEntity<String> startTask = applicationController.startTask(string);
        Asserter.assertNotNull(startTask);
    }

    @Test
    @EnabledOnOs({OS.WINDOWS, OS.MAC})
    void stopTask() {
        String string = mock(String.class);
        ResponseEntity<String> stopTask = applicationController.stopTask(string);
        Asserter.assertNotNull(stopTask);
    }

    @Test
    @EnabledOnOs({OS.WINDOWS, OS.MAC})
    void getRunningTasks() {
        ResponseEntity<String> getRunningTasks = applicationController.getRunningTasks();
        Asserter.assertNotNull(getRunningTasks);
    }
}
