package com.tykj.dev.device.allot.subject.vo;

import com.tykj.dev.device.allot.subject.domin.AllotBackBill;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配发退回单存储类")
public class AllotBackBillSaveVo {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "配发退回业务主键id")
    private Integer taskId;

    @NotNull(message = "applyNumber不能为空")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @NotNull(message = "replayNumber不能为空")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @NotNull(message = "sendUnit不能为空")
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    @NotNull(message = "receiveUnit不能为空")
    @ApiModelProperty(value = "接收单位")
    private String receiveUnit;

    @NotNull(message = "receiveUseraId不能为空")
    @Min(value = 1,message = "receiveUseraId不能小于1")
    @ApiModelProperty(value = "收件方(A岗位)")
    private Integer receiveUseraId;

    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "账单文件名")
    private String fileName;

    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "账单文件地址URL")
    private String fileUrl;

    @NotNull(message = "backCount不能为空")
    @ApiModelProperty(value = "退回设备数量")
    private Integer backCount;

    @NotNull(message = "backedCount不能为空")
    @ApiModelProperty(value = "已退回设备数量")
    private Integer backedCount;

    @NotBlank(message = "backCheckDetail不能为空")
    @ApiModelProperty(value = "退回出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配)")
    private String backCheckDetail;

    @NotBlank(message = "backCheckResult不能为空")
    @ApiModelProperty(value = "退回出库检查结果")
    private String backCheckResult;

    @ApiModelProperty(value = "签发人")
    private String agent;

    private List<ScriptSaveVo> scriptSaveVos;

    public AllotBackBill toDo() {
        AllotBackBill allotBackBill = new AllotBackBill();
        BeanUtils.copyProperties(this, allotBackBill);
        allotBackBill.setBackStatus(0);
        if (this.scriptSaveVos!=null){
            allotBackBill.setScriptJson(JacksonUtil.toJSon(scriptSaveVos));
        }
        return allotBackBill;
    }
}
