package com.tykj.dev.device.allot.subject.vo;

import com.tykj.dev.device.allot.subject.domin.AllotBackBill;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.TimestampUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配发单类")
public class AllotBillSaveVo {

//    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

    @ApiModelProperty(value = "配发标题")
    private String title;

//    @NotNull(message = "applyNumber不能为空")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

//    @NotNull(message = "replayNumber不能为空")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @NotNull(message = "sendUnit不能为空")
    @ApiModelProperty(value = "配发单位")
    private String sendUnit;

    @NotNull(message = "receiveUnit不能为空")
    @ApiModelProperty(value = "接收单位")
    private String receiveUnit;

//    @NotNull(message = "sendUserbId不能为空")
//    @Min(value = 1,message = "sendUserbId不能小于1")
    @ApiModelProperty(value = "发件方(B岗位)")
    private Integer sendUserbId;

//    @NotNull(message = "receiveUseraId不能为空")
    @Min(value = 1,message = "receiveUseraId不能小于1")
    @ApiModelProperty(value = "收件方(A岗位)")
    private Integer receiveUseraId;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "账单文件名")
    private String fileName;

//    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "账单文件地址URL")
    private String fileUrl;

    @NotNull(message = "allotCount不能为空")
    @ApiModelProperty(value = "配发设备数量")
    private Integer allotCount;

    @NotNull(message = "allotedCount不能为空")
    @ApiModelProperty(value = "已配发设备数量")
    private Integer allotedCount;

    @NotNull(message = "allotCheckDetail不能为空")
    @ApiModelProperty(value = "配发出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配)")
    private String allotCheckDetail;

    @NotNull(message = "allotCheckResult不能为空")
    @ApiModelProperty(value = "配发出库检查结果")
    private String allotCheckResult;

    @ApiModelProperty(value = "签发人")
    private String agent;

    @NotNull(message = "allotType不能为空")
    @ApiModelProperty(value = "配发类型")
    private Integer allotType;

    @ApiModelProperty(value = "申请文号附件名")
    private List<FileRet> applyFiles;

    @ApiModelProperty(value = "批复文号附件名")
    private List<FileRet> replyFiles;

    @ApiModelProperty(value = "左签章Id")
    private String leftSignatureId;

    @ApiModelProperty(value = "是否盖章(1:是，0:否)")
    private Integer isSigned;

    private List<ScriptSaveVo> scriptSaveVos;

    public AllotBill toDo() {
        AllotBill allotBillEntity = new AllotBill();
        BeanUtils.copyProperties(this, allotBillEntity);
        if(this.replyFiles!=null&&this.replyFiles.size()>0){
            allotBillEntity.setReplyFiles(FilesUtil.stringFileToList(this.replyFiles));
        }
        if(this.applyFiles!=null&&this.applyFiles.size()>0){
            allotBillEntity.setApplyFiles(FilesUtil.stringFileToList(this.applyFiles));
        }
        allotBillEntity.setAllotStatus(2);
        allotBillEntity.setSendTime(TimestampUtil.getCurrentTimestamp());
        if (this.scriptSaveVos!=null){
            allotBillEntity.setScriptJson(JacksonUtil.toJSon(scriptSaveVos));
        }
        return allotBillEntity;
    }

    public AllotBackBill toBackDo() {
        AllotBackBill allotBillEntity = new AllotBackBill();
        BeanUtils.copyProperties(this, allotBillEntity);
        if(this.replyFiles!=null&&this.replyFiles.size()>0){
            allotBillEntity.setReplyFiles(FilesUtil.stringFileToList(this.replyFiles));
        }
        if(this.applyFiles!=null&&this.applyFiles.size()>0){
            allotBillEntity.setApplyFiles(FilesUtil.stringFileToList(this.applyFiles));
        }
        allotBillEntity.setBackStatus(0);
        allotBillEntity.setSendTime(TimestampUtil.getCurrentTimestamp());
        allotBillEntity.setBackCheckDetail(this.allotCheckDetail);
        allotBillEntity.setBackCheckResult(this.allotCheckResult);
        allotBillEntity.setBackCount(this.allotCount);
        allotBillEntity.setBackedCount(this.allotedCount);
        if (this.scriptSaveVos!=null){
            allotBillEntity.setScriptJson(JacksonUtil.toJSon(scriptSaveVos));
        }
        return allotBillEntity;
    }
}
