package com.tykj.dev.device.apply.subject.domin;

import com.tykj.dev.device.apply.subject.vo.ApplyBillDetailVo;
import com.tykj.dev.device.apply.subject.vo.ReplyVo;
import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_apply_bill
 * 申请账单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_apply_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("申请账单")
public class DeviceApplyBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "申请类型(1:装备申请，2:退役申请，3:报废申请，4:销毁申请)")
    private Integer applyType;

    @ApiModelProperty(value = "申请后对应业务账单id以x拼接")
    private String billIds;
    /**
     * 申请文号
     */
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 申请单位
     */
    @ApiModelProperty(value = "申请单位")
    private String applyUnit;
    /**
     * 批复单位
     */
    @ApiModelProperty(value = "批复单位")
    private String replyUnit;
    /**
     * 经办人
     */
    @ApiModelProperty(value = "经办人")
    private String agent;
    /**
     * 配发单id
     */
    @ApiModelProperty(value = "配发单id")
    private Integer allotId;
    /**
     * 申请方id(A岗位)
     */
    @ApiModelProperty(value = "申请方id(A岗位)")
    private Integer applyUseraId;
    /**
     * 批复方id(A岗位)
     */
    @ApiModelProperty(value = "批复方id(A岗位)")
    private Integer replyUseraId;
    /**
     * 申请状态(0:申请待审核,1:申请审核失败,2:申请中,3:已批复待审核,4:批复审核失败,5:申请成功)
     */
    @ApiModelProperty(value = "申请状态(0:申请待审核,1:申请审核失败,2:申请完结,3:等待中办回执单,4:等待确认接收中办装备)")
    private Integer applyStatus;
    /**
     * 列装库主键idx数量(,作为分隔符),例如1x2,2x3,意为列装库id为1的申请2件,id为2的申请3件
     */
    @Column(name = "apply_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "列装库主键idx数量(x作为分隔符),例如1x2x2x3,意为列装库id为1的申请2件,id为2的申请3件")
    private String applyDetail;

    @Column(name = "apply_stat",columnDefinition = "TEXT")
    @ApiModelProperty(value = "申请统计Json")
    private String applyStat;
    /**
     * 创建用户id
     */
    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "申请人")
    @Transient
    private String applyUser;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @Column(name = "back_files",columnDefinition = "TEXT")
    private String backFiles;


    @Column(name = "apply_num_files",columnDefinition = "TEXT")
    private String applyNumFiles;

    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @Column(name = "reply_vos",columnDefinition = "TEXT")
    private String replyVos;

    @Transient
    private List<FileRet> replyFileList = new ArrayList<>();

    @Transient
    private List<FileRet> applyFileList = new ArrayList<>();

    @Transient
    private List<FileRet> backFileList = new ArrayList<>();

    @Transient
    private List<FileRet> applyNumFileList = new ArrayList<>();

    @Transient
    private List<ReplyVo> replyVoList = new ArrayList<>();

    @Transient
    private List<ApplyBillDetailVo> applyBillDetailVos = new ArrayList<>();
}
