package com.tykj.dev.device.apply.subject.vo;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("申请后配发类")
public class DeviceApplyAllotSaveVo {

//    @NotNull(message = "sendUserbId不能为空")
//    @Min(value = 1,message = "sendUserbId不能小于1")
    @ApiModelProperty(value = "发件方(B岗位)")
    private Integer sendUserbId;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "账单文件名")
    private String fileName;

//    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "账单文件地址URL")
    private String fileUrl;

    @NotNull(message = "allotCount不能为空")
    @ApiModelProperty(value = "配发设备数量")
    private Integer allotCount;

    @NotNull(message = "allotedCount不能为空")
    @ApiModelProperty(value = "已配发设备数量")
    private Integer allotedCount;

    @NotNull(message = "allotCheckDetail不能为空")
    @ApiModelProperty(value = "配发出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配)")
    private String allotCheckDetail;

    @NotNull(message = "allotCheckResult不能为空")
    @ApiModelProperty(value = "配发出库检查结果")
    private String allotCheckResult;

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "对应任务ID", example = "1")
    private Integer taskId;

    @ApiModelProperty(value = "左签章Id")
    private String leftSignatureId;

    private List<ScriptSaveVo> scriptSaveVos;
}
