package com.tykj.dev.device.apply.subject.vo;

import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.modelmapper.ModelMapper;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备申请存储类")
public class DeviceApplySaveVo {

//    @NotNull(message = "applyNumber不能为空")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

//    @NotNull(message = "replayNumber不能为空")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @NotNull(message = "applyUnit不能为空")
    @ApiModelProperty(value = "申请单位")
    private String applyUnit;

    @NotNull(message = "replyUnit不能为空")
    @ApiModelProperty(value = "批复单位")
    private String replyUnit;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @NotNull(message = "applyUseraId不能为空")
    @Min(value = 1,message = "applyUseraId不能小于1")
    @ApiModelProperty(value = "申请人id")
    private Integer applyUseraId;

    @Min(value = 1,message = "replyUseraId不能小于1")
    @ApiModelProperty(value = "批复人id")
    private Integer replyUseraId;

    @Valid
    @NotEmpty(message = "storageBillDetailVoList不能为空")
    @ApiModelProperty(value = "入库列装数量详情")
    private List<ApplyBillDetailVo> storageBillDetailVoList;

    @ApiModelProperty(value = "申请附件")
    private List<FileRet> applyFiles;

    @ApiModelProperty(value = "申请文号附件")
    private List<FileRet> applyNumFiles;

    @ApiModelProperty(value = "批复文号附件名")
    private List<FileRet> replyFiles;

    @ApiModelProperty(value = "申请类型(1:装备申请，2:退役申请，3:报废申请，4:销毁申请)")
    private Integer applyType;

    public DeviceApplyBill toDo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        DeviceApplyBill deviceApplyBillEntity = mapper.map(this, DeviceApplyBill.class);
        deviceApplyBillEntity.setApplyStatus(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (this.storageBillDetailVoList.size() > 0) {
            for (ApplyBillDetailVo s : storageBillDetailVoList) {
                stringBuffer.append(s.getPackingId()).append("x");
                if (s.getStorageCount()!=null) {
                    stringBuffer.append(s.getStorageCount()).append("x");
                }
                else {
                    stringBuffer.append(0).append("x");
                }
            }
        }
        if (this.storageBillDetailVoList!=null){
            deviceApplyBillEntity.setApplyStat(JacksonUtil.toJSon(this.storageBillDetailVoList));
            if (this.applyType!=1){
                List<ReplyVo> replyVos = new ArrayList<>();
                for (ApplyBillDetailVo applyBillDetailVo : storageBillDetailVoList){
                    ReplyVo replyVo = new ReplyVo();
                    replyVo.setId(applyBillDetailVo.getPackingId());
                    replyVo.setNum(applyBillDetailVo.getStorageCount());
                    replyVo.setSeqInterval(applyBillDetailVo.getSeqInterval());
                    replyVos.add(replyVo);
                }
                deviceApplyBillEntity.setReplyVos(JacksonUtil.toJSon(replyVos));
            }
        }
        deviceApplyBillEntity.setApplyDetail(stringBuffer.toString());
        if(this.applyFiles!=null&&this.applyFiles.size()>0){
            deviceApplyBillEntity.setApplyFiles(FilesUtil.stringFileToList(this.applyFiles));
        }
        if(this.applyNumFiles!=null&&this.applyNumFiles.size()>0){
            deviceApplyBillEntity.setApplyNumFiles(FilesUtil.stringFileToList(this.applyNumFiles));
        }
        if(this.replyFiles!=null&&this.replyFiles.size()>0){
            deviceApplyBillEntity.setReplyFiles(FilesUtil.stringFileToList(this.replyFiles));
        }
        return deviceApplyBillEntity;
    }

}
