package com.tykj.dev.blockcha.controller;

import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.swagger.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;


/**
 * @author dengdiyi
 */
@SuppressWarnings("ALL")
@RestController
@RequestMapping(value = "/blockcha")
@AutoDocument
@Transactional(rollbackFor = Exception.class)
@Slf4j
@Api(tags = "区块链", description = "区块链模块", position = 1)
public class BlockchaController {

    @Autowired
    BlockChainUtil blockChainUtil;

    @GetMapping(value = "/ststus")
    public ResponseEntity getststus(){
        return ResponseEntity.ok(blockChainUtil.getStatus());
    }

    @GetMapping(value = "/subRegister")
    @ApiOperation("注册")
    public ResponseEntity subRegister(){
        return ResponseEntity.ok(blockChainUtil.subRegister("asdfg"));
    }

    @ApiOperation(value = "添加")
    @GetMapping(value = "/sendHash/{index}/{code}/{content}")
    public ResponseEntity sendHash(@PathVariable Integer index,@PathVariable Integer code,@PathVariable String content){
        return ResponseEntity.ok(blockChainUtil.sendHash(index,code,""));
    }

    @ApiOperation(value = "hash追加")
    @GetMapping(value = "/sendHash3/{index}/{id}/{content}")
    public ResponseEntity sendHash23(@PathVariable Integer index,@PathVariable String id,@PathVariable String content){
        return ResponseEntity.ok(blockChainUtil.appendHash(index,content,id));
    }

    @ApiOperation(value = "文本添加")
    @GetMapping(value = "/sendHash1/{index}/{code}/{content}")
    public ResponseEntity sendHash1(@PathVariable Integer index,@PathVariable Integer code,@PathVariable String content){
        return ResponseEntity.ok(blockChainUtil.sendText(index,code,"{21312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd287398127938712987398217938719287398127983791287398712987398127938712987398127983798126398126398621983681276387126783621876387126873621876387216387162873687126387216873612786387126873612873678126378216836213//asdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd287398127938712987398217938719287398127983791287398712987398127938712987398127983798126398126398621983681276387126783621876387126873621876387216387162873687126387216873612786387126873612873678126378216836213"+content+"21312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasdd21312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd28739812793871298739821793871928739812798379128739871298739812793871298739812798379812639812639862198368127638712678362187638712687362187638721638716287368712638721687361278638712687361287367812637821683621321312987398798127398791jjjasjdh000asdsadasdsadasddasdsadsadasdasdasjhdjsgahjdghsaghdgashgdjhasgjdhgasjhdgajshd287398127938712987398217938719287398127983791287398712987398127938712987398127983798126398126398621983681276387126783621876387126873621876387216387162873687126387216873612786387126873612873678126378216836213"));
    }

    @ApiOperation(value = "文本最佳添加")
    @GetMapping(value = "/sendHash2/{index}/{id}/{content}")
    public ResponseEntity sendHash2(@PathVariable Integer index,@PathVariable String id,@PathVariable String content){
        return ResponseEntity.ok(blockChainUtil.appendText(index,content,id));
    }

    @ApiOperation(value = "key and id")
    @GetMapping(value = "/sendHash5/{key}/{id}")
    public ResponseEntity sendHash5(@PathVariable String key,@PathVariable String id){

        return ResponseEntity.ok(blockChainUtil.verifyText1(id,key));
    }


    @GetMapping(value = "/fetchRecord/{id}")
    @ApiOperation(value = "查询接口")
    public ResponseEntity fetchRecord(@PathVariable String id){
        return ResponseEntity.ok(blockChainUtil.fetchRecord(id));
    }

}




