package com.tykj.dev.config;

import lombok.AllArgsConstructor;

import static com.tykj.dev.misc.base.StatusEnum.*;
import static com.tykj.dev.misc.base.BusinessEnum.*;

/**
 * @author dengdiyi
 */
@AllArgsConstructor
public enum LogType {

    /**
     * 发起列装
     */
    PACKING_1(1,PACKING.id,ORIGIN_STATUS.id, PACKING_CONFIRM.id, "发起列装"),
    /**
     * 列装审核成功
     */
    PACKING_2(2,PACKING.id, PACKING_CONFIRM.id, END.id, "列装审核成功"),
    /**
     * 列装审核失败
     */
    PACKING_3(3,PACKING.id, PACKING_CONFIRM.id, ARCHIVE.id, "列装审核失败"),

    STORAGE_1(4,STORAGE.id, ORIGIN_STATUS.id, END.id, "发起装备入库"),

    STORAGE_2(5,STORAGE.id, WAIT_STORAGE.id, END.id, "发起装备入库"),

    STORAGE_3(6,STORAGE.id, ORIGIN_STATUS.id, WAIT_STORAGE.id, "保存入库草稿"),

    ALLOT_1(7,ALLOT.id, ALLOT_DRAFT.id, ALLOTING.id, "对(%receiveUnit)发起配发"),

    ALLOT_2(8,ALLOT.id, ORIGIN_STATUS.id, ALLOT_DRAFT.id, "保存配发草稿"),

    ALLOT_3(9,ALLOT.id, ALLOT_DRAFT.id, ARCHIVE.id, "删除配发草稿"),

    ALLOT_4(10,ALLOT.id, WAIT_UPLOAD_ALLOT_FILE.id, END.id, "上传配发单"),

    ALLOT_5(11,ALLOT.id, WAIT_UPLOAD_ALLOT_FILE.id, ARCHIVE.id, "取消上传配发单"),

    ALLOT_6(12,ALLOT.id, ORIGIN_STATUS.id, WAIT_UPLOAD_CROSS_FILE.id, "对(%receiveUnit)发起配发"),

    ALLOT_7(13,ALLOT.id, WAIT_UPLOAD_CROSS_FILE.id, END.id, "上传配发单"),

    RFID_1(14,TAG.id, ORIGIN_STATUS.id, RFID_BUSINESS_NEED_CONFIRM.id, "发起标签替换"),

    RFID_2(15,TAG.id, RFID_BUSINESS_NEED_CONFIRM.id, END.id, "标签替换审核成功"),

    RFID_3(16,TAG.id, RFID_BUSINESS_NEED_CONFIRM.id, ARCHIVE.id, "标签替换审核失败"),

    SELF_CHECK_1(17,SELF_CHECK.id, ORIGIN_STATUS.id, SELF_CHECK_CONFIRM.id, "手动自查"),

    SELF_CHECK_2(18,SELF_CHECK.id, WAIT_SELF_CHECK.id, SELF_CHECK_CONFIRM.id, "周期自查"),

    SELF_CHECK_3(19,SELF_CHECK.id, SELF_CHECK_CONFIRM.id, END.id, "上传自查单"),

    SELF_CHECK_4(20,SELF_CHECK.id, SELF_CHECK_CONFIRM.id, ARCHIVE.id, "自查审核失败"),

    APPLY_1(21,APPLY.id, ORIGIN_STATUS.id, DEVICE_APPLY_CONFIRM.id, "发起装备申请"),

    APPLY_2(22,APPLY.id, DEVICE_APPLY_CONFIRM.id, END.id, "装备申请批复通过"),

    APPLY_3(23,APPLY.id, DEVICE_APPLY_CONFIRM.id, ARCHIVE.id, "装备申请批复驳回"),

    DESTROY_1(24,DESTROY.id, ORIGIN_STATUS.id, WAIT_UPLOAD_BILL_FILE.id, "发起销毁"),

    DESTROY_3(26,DESTROY.id, DESTROY_BUSINESS_NEED_CONFIRM.id, ARCHIVE.id, "销毁出库审核失败"),

    MATCHING_1(27,ADD_MATCHING_DEVICE.id, ORIGIN_STATUS.id, END.id, "发起新增配套设备"),

    MATCHING_2(28,ADD_MATCHING_DEVICE.id, ADD_MATCHING_DEVICE_CONFIRM.id, END.id, "添加配套设备审核成功"),

    MATCHING_3(29,ADD_MATCHING_DEVICE.id, ADD_MATCHING_DEVICE_CONFIRM.id, ARCHIVE.id, "添加配套设备审核失败"),

    REPAIR_SEND_1(30,REPAIR.id, ORIGIN_STATUS.id, WAIT_RECEIVE.id, "向(%receiveUnit)发起装备维修"),

    REPAIR_SEND_2(31,REPAIR.id, REPAIR_SEND_CONFIRM.id, WAIT_RECEIVE.id, "审核成功并出库"),

    DESTROY_2(25,DESTROY.id, DESTROY_BUSINESS_NEED_CONFIRM.id, WAIT_UPLOAD_BILL_FILE.id, "销毁出库审核成功"),

    REPAIR_SEND_3(32,REPAIR.id, REPAIR_SEND_CONFIRM.id, ARCHIVE.id, "维修出库审核失败"),

    REPAIR_SEND_4(33,REPAIR.id, WAIT_RECEIVE.id, END.id, "接收维修装备并发起入库"),

    DESTROY_4(100,DESTROY.id, WAIT_UPLOAD_BILL_FILE.id, END.id, "上传销毁单"),

    REPAIR_SEND_5(34,REPAIR.id, WAIT_RECEIVE.id, WAIT_UPLOAD_FILE.id, "接收维修装备并发起入库(缺少单据)"),

    REPAIR_SEND_6(35,REPAIR.id, WAIT_UPLOAD_FILE.id, END.id, "上传送修单据"),

    REPAIR_SEND_7(36,REPAIR.id, REPAIR_SEND_CONFIRM.id, COUNTRY_REPAIRING.id, "审核成功并出库"),

    REPAIR_BACK_1(37,REPAIR_BACK.id, ORIGIN_STATUS.id, WAIT_BACK_RECEIVE.id, "向(%receiveUnit)退还维修装备"),

    REPAIR_BACK_2(38,REPAIR_BACK.id, WAIT_BACK_RECEIVE.id, WAIT_UPLOAD_BACK_FILE.id, "维修退回装备接收并发起入库(缺失单据)"),

    REPAIR_BACK_3(39,REPAIR_BACK.id, WAIT_UPLOAD_BACK_FILE.id, END.id, "上传领取单据"),

    REPAIR_BACK_4(40,REPAIR_BACK.id, WAIT_BACK_RECEIVE.id, END.id, "维修退回装备接收并发起入库"),

    REPAIR_BACK_5(41,REPAIR_BACK.id, ORIGIN_STATUS.id, WAIT_UPLOAD_BACK_FILE.id, "维修退回装备接收并发起入库(缺失单据)"),

    REPAIR_BACK_6(42,REPAIR_BACK.id, WAIT_UPLOAD_BACK_SEND_FILE.id, ARCHIVE.id, "取消上传领取单"),

    RETIRED_1(43,RETIRED.id, ORIGIN_STATUS.id, END.id, "发起退装"),

    RETIRED_2(44,RETIRED.id,RETIRED_BUSINESS_NEED_CONFIRM.id, END.id, "退装审核成功"),

    RETIRED_3(45,RETIRED.id, RETIRED_BUSINESS_NEED_CONFIRM.id, ARCHIVE.id, "退装审核失败"),

    TRAIN_1(46,TRAIN.id, ORIGIN_STATUS.id, TRAIN1000.id, "发起培训"),

    CONFIRM_CHECK_DETAIL_NORMAL_0(401,CONFIRM_CHECK_DETAIL.id, ORIGIN_STATUS.id, CHECK_DETAIL_0.id, "核查详情任务开始"),

    CONFIRM_CHECK_DETAIL_NORMAL_1(402,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_0.id, CHECK_DETAIL_1.id, "A岗核查成功,等待专管员B操作"),

    CONFIRM_CHECK_DETAIL_NORMAL_2(403,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_1.id, CHECK_DETAIL_2.id, "B岗核查成功,等待核查组成员A审核"),

    CONFIRM_CHECK_DETAIL_NORMAL_3(404,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_2.id, CHECK_DETAIL_3.id, "核查组成员A核查成功,等待核查组成员B审核"),

    CONFIRM_CHECK_DETAIL_NORMAL_4(405,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_3.id, END.id, "核查组成员B核查成功,任务结束,上传数据到统计信息"),

    CONFIRM_CHECK_DETAIL_OTHER_1(406,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_1.id, END.id, "B岗核查成功,该任务没有核查组成员,任务结束,上传数据到统计信息"),

    CONFIRM_CHECK_DETAIL_OTHER_2(407,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_1.id, CHECK_DETAIL_0.id, "B岗审核失败,跳回A岗人员操作"),

    CONFIRM_CHECK_DETAIL_OTHER_3(408,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_2.id, CHECK_DETAIL_0.id, "核查组成员A审核失败,跳回A岗人员操作"),

    CONFIRM_CHECK_DETAIL_OTHER_4(409,CONFIRM_CHECK_DETAIL.id, CHECK_DETAIL_3.id, CHECK_DETAIL_0.id, "核查组成员B审核失败,跳回A岗人员操作"),

    CONFIRM_CHECK_DETAIL_STAT_0(410,CONFIRM_CHECK_STAT.id, ORIGIN_STATUS.id, CHECK_STAT_0.id, "核查统计任务开始"),

    CONFIRM_CHECK_DETAIL_STAT_1(411,CONFIRM_CHECK_STAT.id, CHECK_STAT_0.id, CHECK_STAT_1.id, "地区数据已统计完毕,等待确认"),

    CONFIRM_CHECK_DETAIL_STAT_2(412,CONFIRM_CHECK_STAT.id, CHECK_STAT_1.id, END.id, "地区数据已确认完毕,将统计上传,任务完结"),

    CONFIRM_CHECK_EXAM_STAT_0(413, CONFIRM_CHECK_STAT.id, ORIGIN_STATUS.id, CHECK_EXAM_STAT_0.id, "检查统计任务开始"),

    CONFIRM_CHECK_EXAM_STAT_1(414, CONFIRM_CHECK_STAT.id, CHECK_EXAM_STAT_0.id, CHECK_EXAM_STAT_1.id, "检查统计数据已统计完毕,等待确认"),

    CONFIRM_CHECK_EXAM_STAT_2(415, CONFIRM_CHECK_STAT.id, CHECK_EXAM_STAT_1.id, END.id, "检查统计任务数据已确认完毕，任务完结"),

    CONFIRM_CHECK_EXAM_DETAIL_0(416, CONFIRM_CHECK_DETAIL.id, ORIGIN_STATUS.id, CHECK_EXAM_DETAIL_0.id, "检查详情任务开始"),

    CONFIRM_CHECK_EXAM_DETAIL_1(417, CONFIRM_CHECK_DETAIL.id, CHECK_EXAM_DETAIL_0.id, CHECK_EXAM_DETAIL_1.id, "A岗核查成功,等待专管员B操作"),

    CONFIRM_CHECK_EXAM_DETAIL_2(418, CONFIRM_CHECK_DETAIL.id, CHECK_EXAM_DETAIL_1.id, END.id, "专管员B核查成功,该地区的检查任务结束了"),

    CONFIRM_CHECK_EXAM_DETAIL_3(419, CONFIRM_CHECK_DETAIL.id, CHECK_EXAM_DETAIL_1.id, CHECK_EXAM_DETAIL_0.id, "B岗审核失败,跳回A岗人员操作"),

    CONFIRM_CHECK_EXAM_STAT_3(420, CONFIRM_CHECK_DETAIL.id, CHECK_EXAM_STAT_0.id, END.id, "检查统计任务数据已确认完毕，任务完结"),

    ALLOT_BACK_1(57, ALLOT_BACK.id, ORIGIN_STATUS.id, ALLOT_BACKING.id, "发起装备退回"),

    ALLOT_BACK_2(58,ALLOT_BACK.id, ALLOT_BACKING.id, END.id, "退回装备接收成功"),

    ALLOT_BACK_3(59,ALLOT_BACK.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, END.id, "上传退回单"),

    ALLOT_BACK_4(60,ALLOT_BACK.id, ALLOT_BACKING.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, "退回装备接收成功(缺失单据)"),

    TRAIN1(61, TRAIN.id, ORIGIN_STATUS.id, TRAIN1000.id, "创建培训成功,等待报名"),
    TRAIN2(62, TRAIN.id, TRAIN1000.id, TRAIN1010.id, "报名结束,待培训"),
    TRAIN3(63, TRAIN.id, TRAIN1010.id, TRAIN1004.id, "培训中"),
    TRAIN4(64, TRAIN.id, TRAIN1004.id, TRAIN1005.id, "市培训成绩录入完成"),
    TRAIN5(65, TRAIN.id, TRAIN1005.id, TRAIN1006.id, "市向省申请发证"),
    TRAIN6(66, TRAIN.id, TRAIN1006.id, END.id, "市培训完成"),
    TRAIN7(67, TRAIN.id, TRAIN1004.id, TRAIN1007.id, "省培训成绩录入完成，等待审核"),
    TRAIN8(68, TRAIN.id, TRAIN1007.id, END.id, "省培训完成"),

    SEND_BACK_1(69,SEND_BACK_STATISTICAL.id, ORIGIN_STATUS.id, SEND_BACK_1200.id, "省发起清退任务,等待下属单位把需要清退到装备送至省单位"),
    SEND_BACK_2(70,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1201.id, "省发起对市发起清退任务"),
    SEND_BACK_3(71,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1202.id, "省发起省直属单位清退装备提交任务"),
    SEND_BACK_4(72,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1203.id, "省对着自己发起装备清退任务，清退自己单位对装备"),
    SEND_BACK_7(75,SEND_BACK_STATISTICAL.id, ORIGIN_STATUS.id, SEND_BACK_1204.id, "转发了省级清退任务，生成市对清退统计任务"),
    SEND_BACK_8(76,SEND_BACK.id, ORIGIN_STATUS.id, SEND_BACK_1205.id, "市转发了省清退任务，对区县发起了清退任务"),
    SEND_BACK_9(77,SEND_BACK.id, SEND_BACK_1201.id, SEND_BACK_1206.id, "市等待下级单位提交清退装备，在选择装备库送至省里"),
    SEND_BACK_10(78,SEND_BACK.id, SEND_BACK_1205.id,SEND_BACK_1206.id , "区县根据清退通知，选择了需要清退对装备"),
    SEND_BACK_11(10001,SEND_BACK.id, SEND_BACK_1206.id,SEND_BACK_1207.id , "选择需要清退对装备，提交等待上级审核"),
    SEND_BACK_12(10002,SEND_BACK.id, SEND_BACK_1207.id,SEND_BACK_1208.id , "上级审核通过，可以进行出库，把装备送至上级"),
    SEND_BACK_13(10003,SEND_BACK.id, SEND_BACK_1208.id,SEND_BACK_1209.id , "清退装备已出库，等待单位接收"),
    SEND_BACK_14(10004,SEND_BACK.id, SEND_BACK_1209.id,END.id , "单位接收完成"),
    SEND_BACK_15(10005,SEND_BACK.id, SEND_BACK_1207.id,SEND_BACK_1206.id , "上级审核不通过"),
    SEND_BACK_16(10006,SEND_BACK.id, SEND_BACK_1206.id,SEND_BACK_1208.id , "全部清退任务，不需要审核，等待清退装备出库"),

    //退役
    SEND_BACK_17(10007,DECOMMISSIONING.id, ORIGIN_STATUS.id,SEND_BACK_1210.id , "发起退役任务，等待中办签字单据"),
    SEND_BACK_18(10008,DECOMMISSIONING.id, SEND_BACK_1210.id,END.id , "上传中办签字单据，任务结束"),

    SEND_BACK_19(10009,SEND_BACK.id, ORIGIN_STATUS.id,SEND_BACK_1211.id , "市发起清退任务，待省级单位审核"),
    SEND_BACK_20(100010,SEND_BACK.id, SEND_BACK_1211.id,END.id , "省对单位审核不通过，任务结束"),
    SEND_BACK_21(100011,SEND_BACK.id, SEND_BACK_1211.id,SEND_BACK_1204.id , "省对单位审核通过，等待下级单位提交"),
    SEND_BACK_23(100013,SEND_BACK.id, SEND_BACK_1212.id,END.id , "清退统计任务已办结"),
    SEND_BACK_24(100014,SEND_BACK_STATISTICAL.id, SEND_BACK_1204.id,SEND_BACK_1212.id , "市清退统计任务待办结"),
    SEND_BACK_25(100015,SEND_BACK_STATISTICAL.id, SEND_BACK_1200.id,SEND_BACK_1212.id , "省清退统计任务待办结"),
    SEND_BACK_26(100016,SEND_BACK.id, SEND_BACK_1214.id,END.id , "清退装备任务，上传了回执单据"),
    SEND_BACK_27(100017,SEND_BACK.id, SEND_BACK_1202.id,SEND_BACK_1213.id , "省直属单位清退装备选择完成，等待签字单据上传"),
    SEND_BACK_28(100018,SEND_BACK.id, SEND_BACK_1213.id,END.id , "上传了直属单位清退签字单据"),
    SEND_BACK_29(100019,SEND_BACK.id, SEND_BACK_1209.id,SEND_BACK_1215.id , "单据未上传,继续等待单据上传"),
    SEND_BACK_30(100020,SEND_BACK.id, SEND_BACK_1215.id,END.id , "接收单据已上传,清退装备配送完成"),
    //重新入库
    AGAINSTORAGE_01(100021,AGAINSTORAGE.id, ORIGIN_STATUS.id,END.id , "发起了装备生命状态转换"),


    LOSS_1(9000,LOSS.id,ORIGIN_STATUS.id,LOSS1300.id,"发起装备丢失上报"),
    LOSS_2(9001,LOSS.id,LOSS1300.id,LOSS1301.id,"确认了装备丢失"),
    LOSS_3(9002,LOSS.id,LOSS1300.id,END.id,"确认了装备丢失报告,报告任务结束"),
    LOSS_4(9003,LOSS.id,ORIGIN_STATUS.id,END.id,"省装备丢失报告发起记录"),
    LOSS_5(9004,LOSS.id,ORIGIN_STATUS.id,LOSS1301.id,"发起丢失装备上报"),
    LOSS_6(9005,LOSS.id,LOSS1301.id,END.id,"发起丢失装备上报,完成"),



    RETRIEVE_1(9010,RETRIEVE.id,ORIGIN_STATUS.id,RETRIEVE1400.id,"发起装备找回上报"),
    RETRIEVE_2(9011,RETRIEVE.id,RETRIEVE1400.id,RETRIEVE1401.id,"确认了装备找回上报"),
    RETRIEVE_3(9012,RETRIEVE.id,RETRIEVE1400.id,END.id,"确认了装备找回上报,找回任务结束"),
    RETRIEVE_4(9013,RETRIEVE.id,ORIGIN_STATUS.id,END.id,"省装备找回报告发起记录"),
    RETRIEVE_5(9014,RETRIEVE.id,ORIGIN_STATUS.id,RETRIEVE1401.id,"发起装备找回上报"),
    RETRIEVE_6(9015,RETRIEVE.id,RETRIEVE1401.id,END.id,"审核装备找回完成，查看找回结果"),


    WORK_H1(79, WORK_HANDOVER.id, ORIGIN_STATUS.id, WORKHANDOVER1011.id, "工作交接任务生成完成,等待上传交接单"),
    WORK_H2(80, WORK_HANDOVER.id, WORKHANDOVER1011.id, END.id, "工作交接完成"),
    ALLOT_8(82, ALLOT.id, ORIGIN_STATUS.id, ALLOTING.id, "对(%receiveUnit)发起配发"),
    ALLOT_9(83, ALLOT.id, ALLOTING.id, END.id, "接收配发装备"),
    ALLOT_10(84, ALLOT.id, WAIT_ALLOT.id, ALLOTING.id, "对(%receiveUnit)发起配发"),
    ALLOT_11(85, ALLOT.id, ALLOTING.id, ARCHIVE.id, "拒绝接收配发装备"),
    ALLOT_BACK_5(86, ALLOT_BACK.id, WAIT_UPLOAD_BACK_FILE_2.id, END.id, "上传退回单"),
    REPAIR_SEND_10(87, REPAIR.id, ORIGIN_STATUS.id, WAIT_UPLOAD_FILE.id, "向(%receiveUnit)发起装备维修"),
    REPAIR_BACK_7(88, REPAIR_BACK.id, ORIGIN_STATUS.id, END.id, "维修退回装备接收并发起入库"),
    STORAGE_4(89, STORAGE.id, WAIT_STORAGE.id, ARCHIVE.id, "删除入库草稿"),
    SCRAP_1(90,SCRAP.id, ORIGIN_STATUS.id, WAIT_UPLOAD_SCRAP_FILE.id, "发起装备报废"),
    SCRAP_2(91,SCRAP.id, WAIT_UPLOAD_SCRAP_FILE.id, END.id, "上传报废单据"),
    SELF_CHECK_5(92,SELF_CHECK.id, ORIGIN_STATUS.id, END.id, "终端自查"),
    SELF_CHECK_6(93,SELF_CHECK.id, WAIT_SELF_CHECK.id, END.id, "周期自查"),
    APPLY_4(94,APPLY.id, ORIGIN_STATUS.id, WAIT_APPLY_FILE.id, "发起申请"),
    REPAIR_BACK_8(95,REPAIR_BACK.id, WAIT_UPLOAD_BACK_SEND_FILE.id, END.id, "上传领取单"),
    REPAIR_SEND_11(96, REPAIR.id, WAIT_UPLOAD_SEND_FILE.id, END.id, "上传送修单"),
    REPAIR_SEND_12(97, REPAIR.id, WAIT_UPLOAD_SEND_FILE.id, ARCHIVE.id, "取消上传送修单"),
    ALLOT_BACK_6(98, ALLOT_BACK.id, WAIT_UPLOAD_BACK_FILE_2.id, ARCHIVE.id, "取消上传退回单"),
    ALLOT_12(99, ALLOT.id, ALLOTING.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, "接收配发装备(缺失单据)"),
    ALLOT_13(101, ALLOT.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, END.id, "上传配发单"),
    ALLOT_14(102,ALLOT.id, WAIT_UPLOAD_ALLOT_RECEIVE_FILE.id, ARCHIVE.id, "取消上传配发单"),
    ALLOT_BACK_7(103, ALLOT_BACK.id, WAIT_UPLOAD_ALLOT_BACK_FILE.id, ARCHIVE.id, "取消上传退回单"),
    REPAIR_SEND_13(104, REPAIR.id, WAIT_UPLOAD_FILE.id, ARCHIVE.id, "取消上传送修单"),
    REPAIR_BACK_9(105,REPAIR_BACK.id, WAIT_UPLOAD_BACK_FILE.id, ARCHIVE.id, "取消上传领取单"),
    APPLY_5(106,APPLY.id, WAIT_APPLY_FILE.id, WAIT_CONFIRM_APPLY_DEVICE.id, "上传批复单"),
    APPLY_6(107,APPLY.id, WAIT_CONFIRM_APPLY_DEVICE.id, END.id, "业务办结"),
    ;

    public Integer id;

    /**
     * 业务类型
     */
    public Integer businessType;
    /**
     * 旧状态
     */
    public Integer oldStatus;

    /**
     * 新状态
     */
    public Integer newStatus;

    /**
     * 执行操作
     */
    public String operation;

    public String getOperation() {
        return this.operation;
    }
}
