package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 配发类型枚举
 */

@AllArgsConstructor
public enum AllotType {
    /**
     * 横向
     */
    HORIZONTAL(1, "省直属横向"),
    /**
     * 纵向
     */
    VERTICAL(2, "省对下纵向");

    public Integer id;

    public String name;


    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("配发类型");
        systemConfig.setEnglishName("allotType");
        return systemConfig;
    }
}
