package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 装备应用类型枚举
 */

@AllArgsConstructor
public enum DeviceApplyType {
    /**
     * 网络
     */
    APPLYTYPE_1(1, "网络"),
    /**
     * 传真
     */
    APPLYTYPE_2(2, "传真"),
    /**
     * 应用
     */
    APPLYTYPE_3(3, "应用"),
    /**
     * 电话
     */
    APPLYTYPE_4(4, "电话"),
    /**
     * 链路
     */
    APPLYTYPE_5(5, "链路");

    public Integer id;

    public String name;

    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("应用类型");
        systemConfig.setEnglishName("applyType");
        return systemConfig;
    }
}
