package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 装备生命状态枚举
 */
@AllArgsConstructor
public enum DeviceLifeStatus {

//    /**
//     * 入库待审核
//     */
//    STORAGE_WAIT_CONFIRM(0, "入库待审核"),
//    /**
//     * 入库审核失败
//     */
//    STORAGE_CONFIRM_FAILED(1, "入库审核失败"),
    /**
     * 在库
     */
    IN_LIBRARY(2, "在库"),
    /**
     * 配发中
     */
    IN_TRANSIT(3, "配发"),
    /**
     * 维修中
     */
    REPAIRING(4, "维修中"),
    /**
     * 报废在省库
     */
    SCRAP_I(5, "已报废"),
    /**
     * 清退
     */
    SEND_BACK(6, "待清退"),
//    /**
//     * 待退装
//     */
//    WAIT_RETIRED(7, "待退装"),
//    /**
//     * 退装
//     */
//    RETIRED(8, "退装"),
//    /**
//     * 待销毁
//     */
//    WAIT_DESTROY(9, "待销毁"),
    /**
     * 已销毁
     */
    DESTROYED(10, "已销毁"),
    /**
     * 丢失
     */
    LOSS(11, "丢失"),
    /**
     * 退役
     */
    RETIRE(12, "退役"),
//    /**
//     * 报废不在省库
//     */
//    SCRAP_II(13, "已报废"),
    /**
     * 使用
     */
    USE(14, "使用"),

    /**
     * 待退役
     */
    REPEL(15,"待退役"),

    /**
     * 退役中
     */
    RETIRED(16,"退役中"),

    /**
     * 待报废
     */
    TO_BE_SCRAPPED(17,"待报废"),

    /**
     * 报废中
     */
    IN_THE_SCRAPPED(18,"报废中"),

    /**
     * 待销毁
     */
    TO_BE_DESTROYED(19,"待销毁"),

    /**
     * 销毁中
     */
    IN_THE_DESTROYED(20,"销毁中");


    public Integer id;

    public String name;

    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("生命状态");
        systemConfig.setEnglishName("lifeStatus");
        return systemConfig;
    }
}
