package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 配用范围枚举
 */

@AllArgsConstructor
public enum MatchingRange {
    /**
     * 中央到省
     */
    MATCHINGRANGE_2(2, "中央到省"),
    /**
     * 省以下纵向
     */
    PROVINCIAL_VERTICAL(1, "省以下纵向"),
    /**
     * 省以下横向
     */
    MATCHINGRANGE_3(3, "省以下横向"),
    /**
     * 其它
     */
    MATCHINGRANGE_4(4, "其它");

    public Integer id;

    public String name;

    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("配用范围");
        systemConfig.setEnglishName("matchingRange");
        return systemConfig;
    }
}
