package com.tykj.dev.config.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * 系统变量实体类
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("系统变量表")
public class SystemVariable {

    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "变量名")
    private String name;

    @ApiModelProperty(value = "变量值")
    private String vaule;
}
