package com.tykj.dev.config.service.impl;

import com.tykj.dev.config.domin.SystemVariable;
import com.tykj.dev.config.repository.SystemVariableDao;
import com.tykj.dev.config.service.SystemVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author dengdiyi
 */
@Service
public class SystemVariableServiceImpl implements SystemVariableService {

    @Autowired
    private SystemVariableDao systemVariableDao;

    @Override
    public SystemVariable add(SystemVariable systemVariable) {
        return systemVariableDao.save(systemVariable);
    }

    @Override
    public String getVaule(String name) {
        return systemVariableDao.findByName(name).getVaule();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SystemVariable setVaule(String name,String vaule) {
        SystemVariable systemVariable = systemVariableDao.findByName(name);
        systemVariable.setVaule(vaule);
        return systemVariableDao.save(systemVariable);
    }
}
