package com.tykj.dev.config.vo;

import com.tykj.dev.config.domin.SystemConfig;
import com.tykj.dev.config.service.SystemConfigService;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配置变量存储类")
public class ConfigVo {

    @ApiModelProperty(value = "英文变量名")
    private String englishName;

    @ApiModelProperty(value = "中文变量名")
    private String chineseName;

    @ApiModelProperty(value = "变量值显示名")
    private String label;

    public SystemConfig toDo(){
        SystemConfigService systemConfigService = SpringUtils.getBean("systemConfigServiceImpl");
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setEnglishName(englishName);
        systemConfig.setChineseName(chineseName);
        systemConfig.setLabel(label);
        if (systemConfigService != null) {
            systemConfig.setValue(systemConfigService.getMaxValue(englishName)==null?1:systemConfigService.getMaxValue(englishName)+1);
        }
        return systemConfig;
    }
}
