package com.tykj.dev.device.confirmcheck.common;

import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.bto.AreaUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * UnitAreaBean.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/1/18 at 4:45 下午
 */
@Configuration
public class UnitAreaBean {

    @Autowired
    private AreaDao areaDao;

    @Autowired
    private UnitsDao unitsDao;

    @Bean(name = "unMap")
    public Map<String, AreaUnit> unitNameMap() {
        return unitsDao.findAll().stream()
                .filter(units -> units.getType() == 1)
                .map(unit -> {
                    int areaId = unitsDao.findAreaIdByName(unit.getName());
                    Area area = areaDao.findById(areaId).get();
                    return new AreaUnit(area, unit);
                }).collect(Collectors.toMap(AreaUnit::getUnitName, Function.identity()));

    }
}
