package com.tykj.dev.device.confirmcheck.entity.cache;

import com.tykj.dev.config.cache.ConfigCache;
import com.tykj.dev.config.repository.SystemConfigDao;
import com.tykj.dev.device.user.cache.AreaCache;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.cache.UserCache;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.dao.UserDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * CacheBeanConfig.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/22 at 6:24 下午
 */
@Configuration
public class CacheBeanConfig {

    @Autowired
    private AreaDao areaRepo;

    @Autowired
    private UserDao userDao;

    @Autowired
    private UnitsDao unitsDao;

    @Autowired
    private SystemConfigDao systemConfigDao;

    @Bean
    public AreaCache initAreaCache() {
        return new AreaCache(areaRepo.findAll());
    }

    @Bean
    public UserCache initUserCache() {
        return new UserCache(userDao.findAll());
    }

    @Bean
    public UnitsCache initUnitCache() {
        return new UnitsCache(unitsDao.findAll());
    }

    @Bean
    public ConfigCache initConfigCache(){
        return new ConfigCache(systemConfigDao.findAll());
    }
}
