package com.tykj.dev.device.confirmcheck.entity.domain;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.utils.TimestampUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * entity class for device_check_detail
 * 核查详情
 *
 * @author matrix
 */
@SuppressWarnings("ALL")
@Data
@Entity
@SQLDelete(sql = "update device_check_detail set delete_tag = 1 where id = ?")
@ApiModel("核查详情")
@NoArgsConstructor
@Table(name = "device_check_detail")
public class DeviceCheckDetail extends BaseEntity {

    /**
     * 检查详情名称
     */
    @ApiModelProperty(name = "检查详情名称")
    private String title;
    /**
     * 核查账单id
     */

    @ApiModelProperty(value = "核查账单id")
    private Integer finalCheckId;
    /**
     * 检查组成员1(省A岗)id
     */

    @ApiModelProperty(value = "检查组成员1(省A岗)id")
    @Column(name = "check_userA_id")
    private Integer checkUserAId = 0;
    /**
     * 检查组成员2(省A岗)id
     */

    @ApiModelProperty(value = "检查组成员2(省A岗)id")
    @Column(name = "check_userB_id")
    private Integer checkUserBId = 0;
    /**
     * 本级经办人id(A岗)
     */

    @ApiModelProperty(value = "本级经办人id(A岗)")
    @Column(name = "userA_id")
    private Integer userAId;
    /**
     * 本级审核人id(B岗)
     */

    @ApiModelProperty(value = "本级审核人id(B岗)")
    @Column(name = "userB_id")
    private Integer userBId;
    /**
     * 核查时间
     */

    @ApiModelProperty(value = "核查时间")
    private Date checkTime;
    /**
     * 核查单位
     */

    @ApiModelProperty(value = "核查单位")
    private String checkUnit;
    /**
     * 应查数量
     */

    @ApiModelProperty(value = "应查数量")
    private Integer checkingCount;
    /**
     * 实查数量
     */

    @ApiModelProperty(value = "实查数量")
    private Integer checkedCount;
    /**
     * 核查结果
     */

    @ApiModelProperty(value = "核查结果")
    private String checkResult;
    /**
     * 核查详情(装备主键id+核对结果(0缺失1无误2新增3不在库9未检查,字符-作为状态分隔符字符,作为分隔符))
     */
    @Column(name = "check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "核查详情(装备主键id+核对结果(0缺失1无误2新增3不在库9未检查,字符x作为分隔符)),例如1-2,2-2,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String checkDetail;
    /**
     * 核查状态(0:待核查,1:审核失败,2:核查完成)
     */

    @ApiModelProperty(value = "核查状态(0:待核查,1:审核失败,2:核查完成)")
    private Integer checkStatus;

    /**
     * 预留字段1
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 预留字段2
     */
    @ApiModelProperty(value = "预留字段2")
    private String var2;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @Column(name = "check_files",columnDefinition = "TEXT")
    private String checkFiles;

    @Transient
    private List<FileRet> checkFileList = new ArrayList<>();

    /**
     * 用于生成市级的核查详情账单的构造函数
     */
    public DeviceCheckDetail(Integer finalCheckId, Date checkTime, String checkUnit, Integer checkingCount, Integer checkedCount, String checkResult, String checkDetail, Integer checkStatus) {
        this.finalCheckId = finalCheckId;
        this.checkTime = checkTime;
        this.checkUnit = checkUnit;
        this.checkingCount = checkingCount;
        this.checkedCount = checkedCount;
        this.checkResult = checkResult;
        this.checkDetail = checkDetail;
        this.checkStatus = checkStatus;
    }

    /**
     * 用于生成县级的核查详情账单的构造函数
     */
    public DeviceCheckDetail(String title,
                             Integer finalCheckId,
                             Integer checkUserAId,
                             Integer checkUserBId,
                             Integer userAId,
                             Integer userBId,
                             Date checkTime,
                             String checkUnit,
                             Integer checkingCount,
                             Integer checkedCount,
                             String checkResult,
                             String checkDetail,
                             Integer checkStatus,
                             String remark) {
        this.title = title;
        this.finalCheckId = finalCheckId;
        this.checkUserAId = checkUserAId;
        this.checkUserBId = checkUserBId;
        this.userAId = userAId;
        this.userBId = userBId;
        this.checkTime = checkTime;
        this.checkUnit = checkUnit;
        this.checkingCount = checkingCount;
        this.checkedCount = checkedCount;
        this.checkResult = checkResult;
        this.checkDetail = checkDetail;
        this.checkStatus = checkStatus;
        this.remark = remark;
    }

    /**
     * @param checkUnit   要核查的单位
     * @param devInLib    所属与所在均在本单位的装备集合
     * @param devNotInLib 所属在，但所在不在本单位的装备集合
     * @return 初始化的账单(还没有被人修改过的)
     */
    public static DeviceCheckDetail EmptyWithChecker(
            String remark,
            String title,
            Integer checkUserA,
            Integer checkUserB,
            Integer userAId,
            Integer userBId,
            String checkUnit,
            List<DeviceLibrary> devInLib,
            List<DeviceLibrary> devNotInLib) {
        //构造checkDetail 分当前在库与不在库的 赋予不同状态
        String goodCheckDetail = "";
        if (!CollectionUtils.isEmpty(devInLib)) {
            goodCheckDetail = devInLib.stream()
                    .map(device -> device.getId() + "-9")
                    .collect(Collectors.joining(","));
        }

        String badCheckDetail = "";
        if (!CollectionUtils.isEmpty(devNotInLib)) {
            badCheckDetail = devNotInLib.stream()
                    .map(device -> device.getId() + "-3")
                    .collect(Collectors.joining(","));
        }


        //如果不在库的不为空，则拼接，否则没必要
        String checkDetail = StringUtils.isEmpty(badCheckDetail) ? goodCheckDetail : goodCheckDetail + "," + badCheckDetail;

        return new DeviceCheckDetail(
                title + checkUnit + "核查详情单",
                0,
                checkUserA,
                checkUserB,
                userAId,
                userBId,
                TimestampUtil.getNowDate(),
                checkUnit,
                devInLib.size(),
                0,
                "",
                checkDetail,
                0,
                remark
        );
    }
}
