package com.tykj.dev.device.confirmcheck.entity.domain;

import com.tykj.dev.device.confirmcheck.common.CheckType;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * DeviceCheckStat.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:09 下午
 */
@EqualsAndHashCode(callSuper = true)
@SuppressWarnings("AlibabaLowerCamelCaseVariableNaming")
@Data
@Entity
@SQLDelete(sql = "update device_check_stat set delete_tag = 1 where id = ?")
@ApiModel("装备核查统计")
@NoArgsConstructor
@Table(name = "device_check_stat")
public class DeviceCheckStat extends BaseEntity {

    /**
     * 父标题
     */
    private String title;

    /**
     * 子标题
     */
    private String subtitle;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 统计信息以JSON形式存储
     */
    @Column(name = "stat_info",columnDefinition="TEXT")
    private String statInfo;

    /**
     * 检查类型，数据库里的数据结构是int类型，其中1为自动，2为手动
     *
     * @see com.tykj.dev.device.confirmcheck.common.CheckTypeConvert
     */
    private CheckType checkType;

    /**
     * 检查组成员A
     */
    @Column(name = "check_userA_id")
    private Integer checkUserAId;

    /**
     * 检查组成员B
     */
    @Column(name = "check_userB_id")
    private Integer checkUserBId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    /**
     * 备注信息
     */
    private String remark;

    public DeviceCheckStat(String title, String subtitle, LocalDateTime startTime, LocalDateTime endTime, String statInfo) {
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = startTime;
        this.endTime = endTime;
        this.statInfo = statInfo;
    }

    public DeviceCheckStat(String title, String subtitle, LocalDateTime startTime, LocalDateTime endTime, String statInfo, Integer checkUserAId, Integer checkUserBId, String remark) {
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = startTime;
        this.endTime = endTime;
        this.statInfo = statInfo;
        this.checkUserAId = checkUserAId;
        this.checkUserBId = checkUserBId;
        this.remark = remark;
    }

    public DeviceCheckStat(CheckType checkType, String title, String subtitle, String statInfo, Integer checkUserAId, Integer checkUserBId, String remark,LocalDateTime endTime) {
        this.checkType = checkType;
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = LocalDateTime.now();
        this.endTime = endTime;
        this.statInfo = statInfo;
        this.checkUserAId = checkUserAId;
        this.checkUserBId = checkUserBId;
        this.remark = remark;
    }

    public DeviceCheckStat(CheckType checkType, String title, String subtitle, String remark) {
        this.checkType = checkType;
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = LocalDateTime.now();
        this.endTime = LocalDateTime.now().plusMonths(1);
        this.statInfo = "";
        this.checkUserAId = 0;
        this.checkUserBId = 0;
        this.remark = remark;
    }
}
