package com.tykj.dev.device.confirmcheck.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * CheckCheckVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/1/12 at 4:24 下午
 */
@Data
@ApiModel("核查发起对象")
public class CheckCheckVo {

    @ApiModelProperty(name = "核查标题",example = "测试核查标题")
    private String title;

    @ApiModelProperty(name = "核查开始时间",example = "2021-01-12")
    private LocalDate startTime;

    @ApiModelProperty(name = "核查截止时间",example = "2021-01-15")
    private LocalDate endTime;

    @ApiModelProperty(name = "发起单位id")
    private Integer unitId;

    @ApiModelProperty(name = "被核查的区域id集合")
    private List<Integer> areaRange;

    @ApiModelProperty(name = "备注")
    private String remark;
}
