package com.tykj.dev.device.confirmcheck.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * CheckStatTableVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/10/13 at 3:14 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(value = {"queryField"})
@ApiModel("核查统计查询表单")
public class CheckStatTableVo {

    @ApiModelProperty("统计主键id")
    private Integer id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("创建人名称")
    private String creatorName;

    @ApiModelProperty("核查组成员列表")
    private List<String> checkUserNames;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("完成情况")
    private String completion;

    private String queryField;
}
