package com.tykj.dev.device.decommissioning.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.decommissioning.entity.vo.RepelManagementVo;
import com.tykj.dev.device.decommissioning.service.DeviceDecommissioningQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description TODO
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "装备退役查询接口模块", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/decommissioningQuery")
public class DecommissioningQueryController {

    @Autowired
    DeviceDecommissioningQueryService deviceDecommissioningQueryService;


    /**
     * 查询退役中办任务
     */
    @ApiOperation(value = "查询退役中办任务")
    @GetMapping("/outsideTheProvince")
    public ResponseEntity findOutsideTheProvince() {
        return ResponseEntity.ok(deviceDecommissioningQueryService.findOutsideTheProvince());
    }


    /**
     * 查询已办结退役任务列表
     */
    @ApiOperation(value = "查询退役中办任务")
    @GetMapping("/endProvince")
    public ResponseEntity findOutsideTheProvinceEnd() {
        return ResponseEntity.ok(deviceDecommissioningQueryService.findOutsideTheProvinceEnd());
    }


    /**
     * 待清退 待退役
     */
    @PostMapping(value ="/toBeRetiredDeviceList")
    @ApiOperation(value = "待清退", notes = "待清退列表")
    public ResponseEntity clearedList1(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.toBeRetiredDeviceList(repelManagementVo));
    }


    /**
     * 退役中
     */
    @PostMapping(value ="/findRetired")
    @ApiOperation(value = "退役中", notes = "退役中列表")
    public ResponseEntity clearedList2(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findRetired(repelManagementVo));
    }


    /**
     * 已退役
     */
    @PostMapping(value ="/retiredDeviceList")
    @ApiOperation(value = "已退役", notes = "已清退列表")
    public ResponseEntity clearedList4(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.retiredDeviceList(repelManagementVo));
    }


    /**
     * 根据taskId查询业务详情
     */
    @GetMapping(value ="/detail/{taskId}")
    @ApiOperation(value = "根据taskId查询业务详情", notes = "根据taskId查询业务详情")
    public ResponseEntity findDetail(@PathVariable Integer taskId){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findTaskIdDeviceDecommissioningDetail(taskId));
    }

}
