package com.tykj.dev.device.decommissioning.entity.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName StorageDeviceRepel.java
 * @Description 入库参数对象
 * @createTime 2021年01月10日 13:01:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("退役入库参数提交对象")
public class StorageDeviceDevommissiong {
    /**
     * 接收方单据
     */
    private List<FileRet> fileRets;

    /**
     * 装备id集合
     */
    private List<Integer> deviceIds;

    /**
     * 回执单据
     */
    private List<FileRet> outFiles;

    private Integer isIgnore;


    private Integer userId;

    private Integer taskId;

    private Integer userA;

    private Integer userB;

    private String userAName;

    private String userBName;

    private String senderName;

    private Integer senderId;

    /**
     * 电子签章发件方
     */
    private String srcA;

    /**
     * 电子签章收件方
     */
    private String srcB;


    /**
     * 接收方、发件方都使用电子签章
     */
    private Integer isNotTwoSides;

}
