package com.tykj.dev.device.decommissioning.service;

import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.decommissioning.entity.vo.PagingVo;
import com.tykj.dev.device.decommissioning.entity.vo.RepelManagementVo;
import com.tykj.dev.device.task.subject.bto.TaskBto;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDecommissioningQueryService.java
 * @Description TODO
 * @createTime 2021年03月29日 16:39:00
 */
public interface DeviceDecommissioningQueryService {
    /**
     * 查询待中机回执业务代办
     */
    List<TaskBto> findOutsideTheProvince();

    /**
     * 查询退役办结业务
     */
    List<TaskBto> findOutsideTheProvinceEnd();

    /**
     * 查看退役中装备列表
     * @param repelManagementVo 查询条件对象
     * @return PagingVo
     */
    PagingVo findRetired(RepelManagementVo repelManagementVo);


    /**
     * 查看待退役列表装备
     */
    PagingVo toBeRetiredDeviceList(RepelManagementVo repelManagementVo);


    /**
     * 查看已退役装备列表
     */
    PagingVo retiredDeviceList(RepelManagementVo repelManagementVo);


    /**
     * 根据taskId查询退役业务详情
     */
    DeviceDecommissioningDetail findTaskIdDeviceDecommissioningDetail(Integer taskId);
}
