package com.tykj.dev.device.decommissioning.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.tykj.dev.config.base.DeviceLifeStatus;
import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningOrderOutData;
import com.tykj.dev.device.decommissioning.entity.vo.StorageDeviceDevommissiong;
import com.tykj.dev.device.decommissioning.service.DeviceDecommissioningBusinessService;
import com.tykj.dev.device.decommissioning.service.DeviceDecommissioningDetailService;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.DeviceSeqUtil;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.StringUtils;
import com.tykj.dev.misc.utils.TaskDisposeUtil;
import jdk.nashorn.internal.ir.IfNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDecommissioningBusinessServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月29日 16:38:00
 */
@Service
@Slf4j
public class DeviceDecommissioningBusinessServiceImpl implements DeviceDecommissioningBusinessService {

    @Autowired
    UserService userService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    DeviceDecommissioningDetailService deviceDecommissioningDetailService;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Autowired
    TaskService taskService;

    @Autowired
    DeviceLogService deviceLogService;

    @Autowired
    MessageService messageService;

    @Override
    public DeviceDecommissioningDetail provinceSendDecommissioning(Integer userId, DecommissioningOrderOutData decommissioningOrderOutData) {
        User user = userService.findByUser(userId);
        Units units=unitsService.findById(user.getUnitsId());
        DeviceDecommissioningDetail deviceDecommissioningDetail=decommissioningOrderOutData.toDeviceDecommissioningDetail();
        deviceDecommissioningDetail.setDeviceIds(StringUtils.ListToString(decommissioningOrderOutData.getDevIds()));
        deviceDecommissioningDetail.setOutboundFile(FilesUtil.stringFileToList(decommissioningOrderOutData.getOutboundFileList()));
        deviceDecommissioningDetailService.saveDeviceDecommissioningDetail(deviceDecommissioningDetail);
        deviceDecommissioningDetail.setScripts(decommissioningOrderOutData.getScriptSaveVos());
        deviceDecommissioningDetail.setScriptJson(JacksonUtil.toJSon(decommissioningOrderOutData.getScriptSaveVos()));
        deviceDecommissioningDetail.setNum("NO:第"+ LocalDateTime.now().getYear()+"QT"+deviceDecommissioningDetail.getId());
        deviceDecommissioningDetail.setDeviceLibraryEntities(findInvoleDevice(deviceDecommissioningDetail.getDeviceIds()));
        deviceDecommissioningDetailService.saveDeviceDecommissioningDetail(deviceDecommissioningDetail);
        List<ScriptSaveVo> scriptSaveVos=decommissioningOrderOutData.getScriptSaveVos();

        List<String> seqNumbers=new ArrayList<>();
        scriptSaveVos.forEach(
                scriptSaveVo -> {
                    if (scriptSaveVo.getSeqNumber()!=null){
                        seqNumbers.addAll(DeviceSeqUtil.selectDeviceSeqs(scriptSaveVo.getSeqNumber()));
                    }
                }
        );
        deviceLibraryDao.upDateSeqNumbersLeftStatus(DeviceLifeStatus.RETIRED.id,seqNumbers);
        TaskBto taskBto= sendOutSuperior(units.getUnitId(),deviceDecommissioningDetail.getId());
        addMessage(new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"发起退役任务,待上传回执单据",gainThisUser(user.getUserId(),user.getUnitsId())));
        return deviceDecommissioningDetail;
    }

    @Override
    public void receiptSingle(Integer taskId, StorageDeviceDevommissiong storageDeviceDevommissiong) {
        User user=userService.findByUser(storageDeviceDevommissiong.getUserId());
        TaskBto taskBto= taskService.get(taskId);
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.SEND_BACK_1210);
        DeviceDecommissioningDetail deviceDecommissioningDetail=deviceDecommissioningDetailService.findDeviceDecommissioningDetail(taskBto.getBillId());
        deviceDecommissioningDetail.setBillFile(FilesUtil.stringFileToList(storageDeviceDevommissiong.getFileRets()));
        if (storageDeviceDevommissiong.getUserBName()!=null) {
            deviceDecommissioningDetail.setReceiveUserB(storageDeviceDevommissiong.getUserBName());
        }
        if (storageDeviceDevommissiong.getUserB()!=null){
            deviceDecommissioningDetail.setReceiveUserbId(storageDeviceDevommissiong.getUserB());

        }
        if (storageDeviceDevommissiong.getUserA()!=null){
            deviceDecommissioningDetail.setReceiveUseraId(storageDeviceDevommissiong.getUserA());

        }
        if (storageDeviceDevommissiong.getUserAName()!=null) {
            deviceDecommissioningDetail.setReceiveUserA(storageDeviceDevommissiong.getUserAName());
        }
        taskService.moveToEnd(taskBto);
        deviceDecommissioningDetail.setRepelStatus(2);
        List<String> seqNumbers=new ArrayList<>();
        JacksonUtil.readValue(deviceDecommissioningDetail.getScriptJson(), new TypeReference<List<ScriptSaveVo>>() {}).forEach(
                scriptSaveVo -> {
                    if (scriptSaveVo.getSeqNumber()!=null){
                        seqNumbers.addAll(DeviceSeqUtil.selectDeviceSeqs(scriptSaveVo.getSeqNumber()));
                    }
                }
        );
        deviceLibraryDao.upDateSeqNumbersLeftStatusAndUnitNameAndLockStatus(DeviceLifeStatus.RETIRE.id,deviceDecommissioningDetail.getReceiveUnit(),0,seqNumbers);
        deviceDecommissioningDetailService.saveDeviceDecommissioningDetail(deviceDecommissioningDetail);
        addMessage(new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"退役任务回执单据上传成功任务结束",gainThisUser(user.getUserId(),user.getUnitsId())));
    }


    /**
     * 省出库中办 16
     * @param unitId
     * @param repelDetailId
     * @return
     */
    private TaskBto sendOutSuperior(Integer unitId, Integer repelDetailId){
        List<Integer> list=new ArrayList<>();
        list.add(0);
        return taskService.start(new TaskBto(StatusEnum.SEND_BACK_1210.id, "退役设备任务", null, ".", repelDetailId, BusinessEnum.DECOMMISSIONING.id, unitId, 0, "", list));
    }

    /**
     * 异步添加装备日志
     */
    private void devLogAdd(List<DeviceLibrary> deviceLibraries, String remark, Integer userId){
        List<DeviceLog> logDtos=new ArrayList<>();
        deviceLibraries.forEach(
                deviceLibrary -> {
                    logDtos.add(new DeviceLogDto(deviceLibrary.getId(),remark,null,userId).toDo());

                }
        );
        CompletableFuture.runAsync(() -> {
            deviceLogService.saveAllLog(logDtos);
        });

    }

    private void addMessage(MessageBto messageBto){
        messageService.add(messageBto);
    }

    /**
     * 根据单位id查询用户 去除用户id
     * @param userId
     * @param unitId
     * @return
     */
    private List<Integer> gainThisUser(Integer userId,Integer unitId){
        return userService.findAllByUnite(unitId).stream().filter(user -> user.getUnitsId()!=userId).map(User::getUserId).collect(Collectors.toList());
    }

    /**
     * 根据单位id查询用户id集合
     * @param unitId
     * @return
     */
    private List<Integer> findUnitId(Integer unitId){
        return userService.findAllByUnite(unitId).stream().map(User::getUserId).collect(Collectors.toList());
    }

    private List<DeviceLibrary> findInvoleDevice(String involeDevice){
        if (involeDevice!=null && !involeDevice.equals(",") ) {
            List<String> idStringList = Arrays.asList(involeDevice.split(","));
            List<String> idListString = idStringList.stream().filter(list2->!list2.equals("")).collect(Collectors.toList());
            System.out.println(idListString);
            List<Integer> devIds = idListString.stream().map(Integer::parseInt).collect(Collectors.toList());
            return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(devIds).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
    }

}
