package com.tykj.dev.device.destroy.entity.vo;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Transient;
import javax.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DestoryFormVo
 * @packageName com.tykj.dev.device.destory.subject.entity.vo
 **/
@Data
public class DeviceDestroyFormVo {

//    @NotNull(message = "confirmUserId不能为空")
    @ApiModelProperty(value = "待审核人ID", example = "1")
    private Integer confirmUserId;

    @NotEmpty(message = "devices不能为空")
    @ApiModelProperty(value = "装备列表")
    private List<Integer> devices;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "文件名称", example = "文件X")
    private String fileName;

//    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "文件URL", example = "/images/xxxxx")
    private String fileUrl;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "销毁时间")
    private Date destroyTime;


    @ApiModelProperty(value = "销毁单据装备数据")
    private List<ScriptSaveVo> scriptSaveVos = new ArrayList<>();


}
