package com.tykj.dev.device.destroy.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@ApiModel("上传销毁单")
@Data
public class UploadDestroyFileVo {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "业务id")
    private Integer taskId;

    @NotNull(message = "destroyFileName不能为空")
    @ApiModelProperty(value = "销毁附件文件名")
    private String destroyFileName;

    @NotNull(message = "destroyFileUrl不能为空")
    @ApiModelProperty(value = "销毁附件文件地址URL")
    private String destroyFileUrl;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "监销人")
    private String supervisor;
}
