package com.zjty.dev.device.es.subject.service;

import com.zjty.dev.device.es.subject.entity.CollectionRs;
import com.zjty.dev.device.es.subject.entity.EsSource;

import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 1/23/21
 */
public interface EsUtil {

    /**
     * 创建索引
     * @param indexName 索引名称
     * @param mapping mapping
     * @return t or f
     * @throws Exception e
     */
    boolean createIndex(String indexName, Map<String, Object> mapping);

    /**
     * 增量添加数据
     * @param indexName 索引名称
     * @param data
     * @throws IOException
     */
    void bulkAdd(String indexName, @NotNull List<EsSource> data);

    /**
     * 批量删除数据
     * @param indexName 索引名称
     * @param ids id集合
     */
    void bulkDel(String indexName, List<String> ids);

    /**
     * 分页搜索
     * @param indexName 索引名称
     * @param key 搜索关键字
     * @param page 0开始
     * @param size 每页大小
     * @return c
     */
    CollectionRs search(String indexName, String key, int page, int size);

}
